/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.impl.NamedArgumentDescriptorImpl;
import org.jetbrains.plugins.groovy.extensions.impl.StringTypeCondition;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;

public interface NamedArgumentDescriptor {
    public static final NamedArgumentDescriptor SIMPLE_ON_TOP = new NamedArgumentDescriptorImpl(Priority.ALWAYS_ON_TOP);
    public static final NamedArgumentDescriptor SIMPLE_AS_LOCAL_VAR = new NamedArgumentDescriptorImpl(Priority.AS_LOCAL_VARIABLE);
    public static final NamedArgumentDescriptor SIMPLE_NORMAL = new NamedArgumentDescriptorImpl(Priority.NORMAL);
    public static final NamedArgumentDescriptor SIMPLE_UNLIKELY = new NamedArgumentDescriptorImpl(Priority.UNLIKELY);
    public static final NamedArgumentDescriptor TYPE_STRING = new StringTypeCondition("java.lang.String");
    public static final NamedArgumentDescriptor TYPE_CLOSURE = new StringTypeCondition("groovy.lang.Closure");
    public static final NamedArgumentDescriptor TYPE_MAP = new StringTypeCondition("java.util.Map");
    public static final NamedArgumentDescriptor TYPE_LIST = new StringTypeCondition("java.util.List");
    public static final NamedArgumentDescriptor TYPE_BOOL = new StringTypeCondition("java.lang.Boolean");
    public static final NamedArgumentDescriptor TYPE_CLASS = new StringTypeCondition("java.lang.Class");
    public static final NamedArgumentDescriptor TYPE_INTEGER = new StringTypeCondition("java.lang.Integer");

    @NotNull
    public Priority getPriority();

    default public boolean checkType(@NotNull PsiType type, @NotNull GroovyPsiElement context) {
        return true;
    }

    @Nullable
    default public PsiPolyVariantReference createReference(@NotNull GrArgumentLabel label) {
        return null;
    }

    @Nullable
    default public PsiElement getNavigationElement() {
        return null;
    }

    @Nullable
    default public LookupElement customizeLookupElement(@NotNull LookupElementBuilder lookupElement) {
        return null;
    }

    public static enum Priority {
        ALWAYS_ON_TOP,
        AS_LOCAL_VARIABLE,
        NORMAL,
        UNLIKELY;

    }
}

