/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;

public class NamedArgumentReference
extends PsiPolyVariantReferenceBase<GrArgumentLabel> {
    @NotNull
    private final PsiElement myNavigationElement;
    @NotNull
    private final PsiSubstitutor mySubstitutor;

    public NamedArgumentReference(@NotNull GrArgumentLabel element, @NotNull PsiElement navigationElement, @NotNull PsiSubstitutor substitutor) {
        super((PsiElement)element);
        this.myNavigationElement = navigationElement;
        this.mySubstitutor = substitutor;
    }

    public PsiElement resolve() {
        return this.myNavigationElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == this.myNavigationElement) {
            return this.getElement();
        }
        return super.bindToElement(element);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMethod) {
            String newPropertyName;
            PsiMethod method = (PsiMethod)resolved;
            String oldName = ((GrArgumentLabel)this.getElement()).getName();
            if (!method.getName().equals(oldName) && PropertyUtil.isSimplePropertySetter((PsiMethod)method) && (newPropertyName = PropertyUtil.getPropertyName((String)newElementName)) != null) {
                newElementName = newPropertyName;
            }
        }
        return super.handleElementRename(newElementName);
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        return new GroovyResolveResult[]{new GroovyResolveResultImpl(this.myNavigationElement, null, null, this.mySubstitutor, true, true)};
    }
}

