/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockGenerator;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockWithRange;

public class GrLabelBlock
extends GroovyBlockWithRange {
    private final List<Block> myBlocks;

    public GrLabelBlock(@NotNull ASTNode node, List<ASTNode> subStatements, boolean classLevel, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull FormattingContext context) {
        super(node, indent, GrLabelBlock.createTextRange(subStatements), wrap, context);
        GroovyBlockGenerator generator = new GroovyBlockGenerator(this);
        this.myBlocks = generator.generateSubBlockForCodeBlocks(classLevel, subStatements, false);
    }

    private static TextRange createTextRange(List<ASTNode> subStatements) {
        ASTNode first = subStatements.get(0);
        ASTNode last = subStatements.get(subStatements.size() - 1);
        return new TextRange(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    public List<Block> getSubBlocks() {
        return this.myBlocks;
    }
}

