/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.formatter.blocks.ClosureBodyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GrLabelBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrWildcardTypeArgument;

public class GroovyIndentProcessor
extends GroovyElementVisitor {
    public static final int GDOC_COMMENT_INDENT = 1;
    private static final TokenSet GSTRING_TOKENS_INNER = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mDOLLAR});
    private Indent myResult = null;
    private IElementType myChildType;
    private GroovyBlock myBlock;
    private PsiElement myChild;

    @NotNull
    public Indent getChildIndent(@NotNull GroovyBlock parentBlock, @NotNull ASTNode child) {
        this.myChildType = child.getElementType();
        if (parentBlock instanceof ClosureBodyBlock) {
            if (this.myChildType == GroovyElementTypes.PARAMETERS_LIST) {
                return Indent.getNoneIndent();
            }
            if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
                return Indent.getNormalIndent();
            }
        }
        if (parentBlock instanceof GrLabelBlock) {
            ASTNode first = parentBlock.getNode().getFirstChildNode();
            return child == first ? Indent.getNoneIndent() : Indent.getLabelIndent();
        }
        if (GSTRING_TOKENS_INNER.contains(this.myChildType)) {
            return Indent.getAbsoluteNoneIndent();
        }
        PsiElement parent = parentBlock.getNode().getPsi();
        if (parent instanceof GroovyPsiElement) {
            this.myBlock = parentBlock;
            this.myChild = child.getPsi();
            ((GroovyPsiElement)parent).accept(this);
            if (this.myResult != null) {
                return this.myResult;
            }
        }
        return Indent.getNoneIndent();
    }

    @Override
    public void visitAssertStatement(@NotNull GrAssertStatement assertStatement) {
        if (this.myChildType != GroovyTokenTypes.kASSERT) {
            this.myResult = Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitAnnotationArrayInitializer(@NotNull GrAnnotationArrayInitializer arrayInitializer) {
        if (this.myChildType != GroovyTokenTypes.mLBRACK && this.myChildType != GroovyTokenTypes.mRBRACK) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        if (this.myChildType != GroovyTokenTypes.mLBRACK && this.myChildType != GroovyTokenTypes.mRBRACK) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitCaseSection(@NotNull GrCaseSection caseSection) {
        if (this.myChildType != GroovyElementTypes.CASE_LABEL) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
        if (this.myChildType == GroovyElementTypes.CASE_SECTION) {
            this.myResult = GroovyIndentProcessor.getSwitchCaseIndent(this.getGroovySettings());
        }
    }

    @Override
    public void visitLabeledStatement(@NotNull GrLabeledStatement labeledStatement) {
        if (this.myChildType == GroovyTokenTypes.mIDENT) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.myBlock.getContext().getSettings().getIndentOptions();
            if (indentOptions != null && indentOptions.LABEL_INDENT_ABSOLUTE) {
                this.myResult = Indent.getAbsoluteLabelIndent();
            } else if (!this.myBlock.getContext().getGroovySettings().INDENT_LABEL_BLOCKS) {
                this.myResult = Indent.getLabelIndent();
            }
        } else if (this.myBlock.getContext().getGroovySettings().INDENT_LABEL_BLOCKS) {
            this.myResult = Indent.getLabelIndent();
        }
    }

    @Override
    public void visitAnnotation(@NotNull GrAnnotation annotation) {
        this.myResult = this.myChildType == GroovyElementTypes.ANNOTATION_ARGUMENTS ? Indent.getContinuationIndent() : Indent.getNoneIndent();
    }

    @Override
    public void visitArgumentList(@NotNull GrArgumentList list) {
        if (this.myChildType != GroovyTokenTypes.mLPAREN && this.myChildType != GroovyTokenTypes.mRPAREN) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
        if (TokenSets.BLOCK_SET.contains(this.myChildType)) {
            if (this.myChild == ifStatement.getCondition()) {
                this.myResult = Indent.getContinuationWithoutFirstIndent();
            }
        } else if (this.myChild == ifStatement.getThenBranch()) {
            this.myResult = Indent.getNormalIndent();
        } else if (this.myChild == ifStatement.getElseBranch()) {
            this.myResult = this.getGroovySettings().SPECIAL_ELSE_IF_TREATMENT && this.myChildType == GroovyElementTypes.IF_STATEMENT ? Indent.getNoneIndent() : Indent.getNormalIndent();
        }
    }

    @Override
    public void visitAnnotationArgumentList(@NotNull GrAnnotationArgumentList annotationArgumentList) {
        this.myResult = this.myChildType == GroovyTokenTypes.mLPAREN || this.myChildType == GroovyTokenTypes.mRPAREN ? Indent.getNoneIndent() : Indent.getContinuationIndent();
    }

    @Override
    public void visitNamedArgument(@NotNull GrNamedArgument argument) {
        if (this.myChild == argument.getExpression()) {
            this.myResult = Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitDocComment(@NotNull GrDocComment comment) {
        if (this.myChildType != GroovyDocTokenTypes.mGDOC_COMMENT_START) {
            this.myResult = Indent.getSpaceIndent((int)1);
        }
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        if (this.myChild instanceof GrVariable) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitDocTag(@NotNull GrDocTag docTag) {
        if (this.myChildType != GroovyDocTokenTypes.mGDOC_TAG_NAME) {
            this.myResult = Indent.getSpaceIndent((int)1);
        }
    }

    @Override
    public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitThrowsClause(@NotNull GrThrowsClause throwsClause) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitImplementsClause(@NotNull GrImplementsClause implementsClause) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitDocMethodParameterList(@NotNull GrDocMethodParams params) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitExtendsClause(@NotNull GrExtendsClause extendsClause) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitFile(@NotNull GroovyFileBase file) {
        this.myResult = Indent.getNoneIndent();
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (this.myChildType == GroovyElementTypes.PARAMETERS_LIST) {
            this.myResult = Indent.getContinuationIndent();
        } else if (this.myChildType == GroovyElementTypes.THROW_CLAUSE) {
            this.myResult = this.getGroovySettings().ALIGN_THROWS_KEYWORD ? Indent.getNoneIndent() : Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (this.myChildType == GroovyElementTypes.EXTENDS_CLAUSE || this.myChildType == GroovyElementTypes.IMPLEMENTS_CLAUSE) {
            this.myResult = Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitTypeDefinitionBody(@NotNull GrTypeDefinitionBody typeDefinitionBody) {
        if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitOpenBlock(@NotNull GrOpenBlock block) {
        IElementType type = block.getNode().getElementType();
        if (type != GroovyElementTypes.OPEN_BLOCK && type != GroovyElementTypes.CONSTRUCTOR_BODY) {
            return;
        }
        if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
        if (this.myChild == whileStatement.getBody() && !TokenSets.BLOCK_SET.contains(this.myChildType)) {
            this.myResult = Indent.getNormalIndent();
        } else if (this.myChild == whileStatement.getCondition()) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement synchronizedStatement) {
        if (this.myChild == synchronizedStatement.getMonitor()) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement forStatement) {
        if (this.myChild == forStatement.getBody() && !TokenSets.BLOCK_SET.contains(this.myChildType)) {
            this.myResult = Indent.getNormalIndent();
        } else if (this.myChild == forStatement.getClause()) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    private CommonCodeStyleSettings getGroovySettings() {
        return this.myBlock.getContext().getSettings();
    }

    @Override
    public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
        this.myResult = this.myChildType == GroovyTokenTypes.mLPAREN || this.myChildType == GroovyTokenTypes.mRPAREN ? Indent.getNoneIndent() : Indent.getContinuationIndent();
    }

    public static Indent getSwitchCaseIndent(CommonCodeStyleSettings settings) {
        if (settings.INDENT_CASE_FROM_SWITCH) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    @Override
    public void visitParameterList(@NotNull GrParameterList parameterList) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitArrayDeclaration(@NotNull GrArrayDeclaration arrayDeclaration) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitTypeArgumentList(@NotNull GrTypeArgumentList typeArgumentList) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitWildcardTypeArgument(@NotNull GrWildcardTypeArgument wildcardTypeArgument) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitAnnotationMethod(@NotNull GrAnnotationMethod annotationMethod) {
        if (this.myChild instanceof GrAnnotationMemberValue) {
            this.myResult = Indent.getContinuationIndent();
        } else {
            super.visitAnnotationMethod(annotationMethod);
        }
    }

    @Override
    public void visitAnnotationNameValuePair(@NotNull GrAnnotationNameValuePair nameValuePair) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitForClause(@NotNull GrForClause forClause) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitCatchClause(@NotNull GrCatchClause catchClause) {
        this.myResult = this.myChild == catchClause.getBody() ? Indent.getNoneIndent() : Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitTypeParameterList(@NotNull GrTypeParameterList list) {
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }
}

