/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GppClosureParameterTypeProvider
extends AbstractClosureParameterEnhancer {
    @Override
    protected PsiType getClosureParameterType(GrClosableBlock closure, int index) {
        GrListOrMap list;
        Pair<PsiMethod, PsiSubstitutor> pair;
        PsiElement parent = closure.getParent();
        if (parent instanceof GrNamedArgument && (pair = GppClosureParameterTypeProvider.getOverriddenMethod((GrNamedArgument)parent)) != null) {
            PsiParameter[] parameters = ((PsiMethod)pair.first).getParameterList().getParameters();
            if (parameters.length > index) {
                return ((PsiSubstitutor)pair.second).substitute(parameters[index].getType());
            }
            return null;
        }
        if (parent instanceof GrListOrMap && !(list = (GrListOrMap)parent).isMap()) {
            PsiType listType = list.getType();
            int argIndex = Arrays.asList(list.getInitializers()).indexOf(closure);
            assert (argIndex >= 0);
            if (listType instanceof GrTupleType) {
                for (PsiType type : GroovyExpectedTypesProvider.getDefaultExpectedTypes(list)) {
                    GroovyResolveResult[] candidates;
                    if (!(type instanceof PsiClassType)) continue;
                    for (GroovyResolveResult resolveResult : candidates = PsiUtil.getConstructorCandidates((PsiClassType)type, ((GrTupleType)listType).getComponentTypes(), closure)) {
                        PsiType toCastTo;
                        PsiType suggestion;
                        PsiParameter[] parameters;
                        PsiElement method = resolveResult.getElement();
                        if (!(method instanceof PsiMethod) || !((PsiMethod)method).isConstructor() || (parameters = ((PsiMethod)method).getParameterList().getParameters()).length <= argIndex || (suggestion = GppClosureParameterTypeProvider.getSingleMethodParameterType(toCastTo = resolveResult.getSubstitutor().substitute(parameters[argIndex].getType()), index, closure)) == null) continue;
                        return suggestion;
                    }
                }
            }
            return null;
        }
        for (PsiType constraint : GroovyExpectedTypesProvider.getDefaultExpectedTypes(closure)) {
            PsiType suggestion = GppClosureParameterTypeProvider.getSingleMethodParameterType(constraint, index, closure);
            if (suggestion == null) continue;
            return suggestion;
        }
        return null;
    }

    @Nullable
    public static Pair<PsiMethod, PsiSubstitutor> getOverriddenMethod(GrNamedArgument namedArgument) {
        return (Pair)ContainerUtil.getFirstItem(GppClosureParameterTypeProvider.getOverriddenMethodVariants(namedArgument), null);
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getOverriddenMethodVariants(GrNamedArgument namedArgument) {
        GrArgumentLabel label = namedArgument.getLabel();
        if (label == null) {
            return Collections.emptyList();
        }
        String methodName = label.getName();
        if (methodName == null) {
            return Collections.emptyList();
        }
        PsiElement map = namedArgument.getParent();
        if (map instanceof GrListOrMap && ((GrListOrMap)map).isMap()) {
            for (PsiType expected : GroovyExpectedTypesProvider.getDefaultExpectedTypes((GrExpression)map)) {
                if (!(expected instanceof PsiClassType)) continue;
                List<Pair<PsiMethod, PsiSubstitutor>> pairs = GppClosureParameterTypeProvider.getMethodsToOverrideImplementInInheritor((PsiClassType)expected, false);
                return ContainerUtil.findAll(pairs, pair -> methodName.equals(((PsiMethod)pair.first).getName()));
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    public static PsiType getSingleMethodParameterType(@Nullable PsiType type, int index, GrClosableBlock closure) {
        PsiType[] signature = GppClosureParameterTypeProvider.findSingleAbstractMethodSignature(type);
        if (signature != null && GrClosureSignatureUtil.isSignatureApplicable(GrClosureSignatureUtil.createSignature(closure), signature, closure)) {
            return signature.length > index ? signature[index] : PsiType.NULL;
        }
        return null;
    }

    @Nullable
    public static PsiType[] findSingleAbstractMethodSignature(@Nullable PsiType type) {
        List<Pair<PsiMethod, PsiSubstitutor>> result;
        if (type instanceof PsiClassType && !TypesUtil.isClassType(type, "groovy.lang.Closure") && (result = GppClosureParameterTypeProvider.getMethodsToOverrideImplementInInheritor((PsiClassType)type, true)).size() == 1) {
            return GppClosureParameterTypeProvider.getParameterTypes(result.get(0));
        }
        return null;
    }

    public static PsiType[] getParameterTypes(Pair<PsiMethod, PsiSubstitutor> pair) {
        return (PsiType[])ContainerUtil.map2Array((Object[])((PsiMethod)pair.first).getParameterList().getParameters(), PsiType.class, psiParameter -> ((PsiSubstitutor)pair.second).substitute(psiParameter.getType()));
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getMethodsToOverrideImplementInInheritor(PsiClassType classType, boolean toImplement) {
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> over = GppClosureParameterTypeProvider.getMethodsToOverrideImplement(psiClass, false);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> impl = GppClosureParameterTypeProvider.getMethodsToOverrideImplement(psiClass, true);
        for (PsiMethod method : psiClass.getMethods()) {
            (method.hasModifierProperty("abstract") ? impl : over).add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)method, (Object)PsiSubstitutor.EMPTY));
        }
        Iterator iterator = impl.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (!GppClosureParameterTypeProvider.hasTraitImplementation((PsiMethod)pair.first)) continue;
            iterator.remove();
            over.add((Pair<PsiMethod, PsiSubstitutor>)pair);
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result = toImplement ? impl : over;
        int resultSize = result.size();
        for (int i = 0; i < resultSize; ++i) {
            Pair pair = (Pair)result.get(i);
            result.set(i, (Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)pair.first, (Object)resolveResult.getSubstitutor().putAll((PsiSubstitutor)pair.second)));
        }
        return result;
    }

    private static ArrayList<Pair<PsiMethod, PsiSubstitutor>> getMethodsToOverrideImplement(PsiClass psiClass, boolean toImplement) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (CandidateInfo info : OverrideImplementExploreUtil.getMethodsToOverrideImplement((PsiClass)psiClass, (boolean)toImplement)) {
            result.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)info.getElement()), (Object)info.getSubstitutor()));
        }
        return result;
    }

    private static boolean hasTraitImplementation(PsiMethod method) {
        return method.getModifierList().findAnnotation("org.mbte.groovypp.runtime.HasDefaultImplementation") != null;
    }
}

