/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.griffon;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.griffon.GriffonRunConfiguration;

public class GriffonRunConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myConfigurationFactory = new ConfigurationFactory(this){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            return new GriffonRunConfiguration(this, project, GriffonRunConfigurationType.GRIFFON_APPLICATION, "run-app");
        }

        public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
            if (providerID == CompileStepBeforeRun.ID || providerID == CompileStepBeforeRunNoErrorCheck.ID) {
                task.setEnabled(false);
            }
        }
    };
    @NonNls
    private static final String GRIFFON_APPLICATION = "Griffon";

    public String getDisplayName() {
        return GRIFFON_APPLICATION;
    }

    public String getConfigurationTypeDescription() {
        return GRIFFON_APPLICATION;
    }

    public Icon getIcon() {
        return JetgroovyIcons.Griffon.Griffon;
    }

    @NonNls
    @NotNull
    public String getId() {
        return "GriffonRunConfigurationType";
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myConfigurationFactory};
    }

    public static GriffonRunConfigurationType getInstance() {
        return (GriffonRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(GriffonRunConfigurationType.class);
    }
}

