/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallReferenceProcessor;
import com.intellij.ide.hierarchy.call.JavaCallHierarchyData;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrCallReferenceProcessor
implements CallReferenceProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull PsiReference reference, @NotNull JavaCallHierarchyData data) {
        PsiClass originalClass = data.getOriginalClass();
        PsiMethod method = data.getMethod();
        Set methodsToFind = data.getMethodsToFind();
        PsiMethod methodToFind = data.getMethodToFind();
        PsiClassType originalType = data.getOriginalType();
        Map methodToDescriptorMap = data.getResultMap();
        Project project = data.getProject();
        if (reference instanceof GrReferenceExpression) {
            PsiMethod callee;
            PsiClass psiClass;
            PsiType qualifierType;
            GrExpression qualifier = ((GrReferenceExpression)reference).getQualifierExpression();
            if (PsiUtil.isSuperReference(qualifier)) {
                assert (qualifier != null);
                PsiClass superClass = com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)qualifier.getType());
                if (originalClass == null || originalClass.isInheritor(superClass, true)) {
                    return true;
                }
            }
            if (qualifier != null && !methodToFind.hasModifierProperty("static") && (qualifierType = qualifier.getType()) instanceof PsiClassType && !TypeConversionUtil.isAssignable((PsiType)qualifierType, (PsiType)originalType) && methodToFind != method && (psiClass = ((PsiClassType)qualifierType).resolve()) != null && (callee = psiClass.findMethodBySignature(methodToFind, true)) != null && !methodsToFind.contains(callee)) {
                return true;
            }
        } else {
            if (!(reference instanceof PsiElement)) {
                return true;
            }
            PsiElement parent = ((PsiElement)reference).getParent();
            if (parent instanceof PsiNewExpression) {
                if (((PsiNewExpression)parent).getClassReference() != reference) {
                    return true;
                }
            } else if (parent instanceof GrAnonymousClassDefinition) {
                if (((GrAnonymousClassDefinition)parent).getBaseClassReferenceGroovy() != reference) {
                    return true;
                }
            } else {
                return true;
            }
        }
        PsiElement element = reference.getElement();
        PsiMember key = CallHierarchyNodeDescriptor.getEnclosingElement((PsiElement)element);
        Map map = methodToDescriptorMap;
        synchronized (map) {
            CallHierarchyNodeDescriptor d = (CallHierarchyNodeDescriptor)methodToDescriptorMap.get(key);
            if (d == null) {
                d = new CallHierarchyNodeDescriptor(project, (HierarchyNodeDescriptor)((CallHierarchyNodeDescriptor)data.getNodeDescriptor()), element, false, true);
                methodToDescriptorMap.put(key, d);
            } else if (!d.hasReference(reference)) {
                d.incrementUsageCount();
            }
            d.addReference(reference);
        }
        return true;
    }
}

