/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class ConvertJavaStyleArrayIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrClosableBlock block = ((GrMethodCallExpression)element).getClosureArguments()[0];
        String text = block.getText();
        int start = block.getLBrace().getStartOffsetInParent() + 1;
        int finish = block.getRBrace().getStartOffsetInParent();
        String newText = "[" + text.substring(start, finish) + "]";
        GrExpression newExpr = GroovyPsiElementFactory.getInstance(element.getProject()).createExpressionFromText(newText);
        ((GrMethodCallExpression)element).replaceWithStatement(newExpr);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof GrMethodCallExpression)) {
                    return false;
                }
                GrExpression expression = ((GrMethodCallExpression)element).getInvokedExpression();
                if (!(expression instanceof GrNewExpression)) {
                    return false;
                }
                if (((GrNewExpression)expression).getArrayCount() == 0) {
                    return false;
                }
                if (!((GrMethodCallExpression)element).getArgumentList().getText().trim().isEmpty()) {
                    return false;
                }
                GrClosableBlock[] closureArguments = ((GrMethodCallExpression)element).getClosureArguments();
                if (closureArguments.length != 1) {
                    return false;
                }
                GrClosableBlock block = closureArguments[0];
                return block.getLBrace() != null && block.getRBrace() != null;
            }
        };
    }
}

