/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.MyPredicate;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ConvertMapToClassIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.intentions.conversions.ConvertMapToClassIntention");

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrListOrMap map = (GrListOrMap)element;
        GrNamedArgument[] namedArguments = map.getNamedArguments();
        LOG.assertTrue(map.getInitializers().length == 0);
        PsiFile file = map.getContainingFile();
        String packageName = file instanceof GroovyFileBase ? ((GroovyFileBase)file).getPackageName() : "";
        CreateClassDialog dialog = new CreateClassDialog(project, GroovyBundle.message("create.class.family.name", new Object[0]), "", packageName, (ClassKind)GrCreateClassKind.CLASS, true, ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return;
        }
        boolean replaceReturnType = ConvertMapToClassIntention.checkForReturnFromMethod(map);
        boolean variableDeclaration = ConvertMapToClassIntention.checkForVariableDeclaration(map);
        GrParameter methodParameter = ConvertMapToClassIntention.checkForMethodParameter(map);
        String qualifiedClassName = dialog.getClassName();
        String selectedPackageName = StringUtil.getPackageName((String)qualifiedClassName);
        String shortName = StringUtil.getShortName((String)qualifiedClassName);
        GrTypeDefinition typeDefinition = ConvertMapToClassIntention.createClass(project, namedArguments, selectedPackageName, shortName);
        GrTypeDefinition generatedClass = CreateClassActionBase.createClassByType(dialog.getTargetDirectory(), typeDefinition.getName(), PsiManager.getInstance((Project)project), map, "Groovy Class.groovy", true);
        PsiClass replaced = (PsiClass)generatedClass.replace(typeDefinition);
        ConvertMapToClassIntention.replaceMapWithClass(project, map, replaced, replaceReturnType, variableDeclaration, methodParameter);
    }

    public static void replaceMapWithClass(Project project, GrListOrMap map, PsiClass generatedClass, boolean replaceReturnType, boolean variableDeclaration, GrParameter parameter) {
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)generatedClass);
        String text = map.getText();
        int begin = 0;
        int end = text.length();
        if (text.startsWith("[")) {
            ++begin;
        }
        if (text.endsWith("]")) {
            --end;
        }
        GrExpression newExpression = GroovyPsiElementFactory.getInstance(project).createExpressionFromText("new " + generatedClass.getQualifiedName() + "(" + text.substring(begin, end) + ")");
        GrExpression replacedNewExpression = (GrExpression)map.replace(newExpression);
        if (replaceReturnType) {
            PsiType type = replacedNewExpression.getType();
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)replacedNewExpression, GrMethod.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class});
            LOG.assertTrue(method != null);
            GrReferenceAdjuster.shortenAllReferencesIn(method.setReturnType(type));
        }
        if (variableDeclaration) {
            PsiElement parent = PsiUtil.skipParentheses(replacedNewExpression.getParent(), true);
            ((GrVariable)parent).setType(replacedNewExpression.getType());
        }
        if (parameter != null) {
            parameter.setType(newExpression.getType());
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replacedNewExpression);
        IntentionUtils.positionCursor(project, generatedClass.getContainingFile(), (PsiElement)generatedClass);
    }

    public static boolean checkForReturnFromMethod(GrExpression replacedNewExpression) {
        PsiElement expr;
        List<GrStatement> returns;
        PsiElement parent = PsiUtil.skipParentheses(replacedNewExpression.getParent(), true);
        GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)replacedNewExpression, GrMethod.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class});
        if (method == null) {
            return false;
        }
        if (!(parent instanceof GrReturnStatement) && !(returns = ControlFlowUtils.collectReturns(method.getBlock())).contains(expr = PsiUtil.skipParentheses(replacedNewExpression, true))) {
            return false;
        }
        return ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((Project)replacedNewExpression.getProject(), (String)GroovyIntentionsBundle.message("do.you.want.to.change.method.return.type", method.getName()), (String)GroovyIntentionsBundle.message("convert.map.to.class.intention.name", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static boolean checkForVariableDeclaration(GrExpression replacedNewExpression) {
        PsiElement parent = PsiUtil.skipParentheses(replacedNewExpression.getParent(), true);
        return parent instanceof GrVariable && !(parent instanceof GrField) && !(parent instanceof GrParameter) && ((GrVariable)parent).getDeclaredType() != null && replacedNewExpression.getType() != null && (ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((Project)replacedNewExpression.getProject(), (String)GroovyIntentionsBundle.message("do.you.want.to.change.variable.type", ((GrVariable)parent).getName()), (String)GroovyIntentionsBundle.message("convert.map.to.class.intention.name", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0);
    }

    @Nullable
    private static GrParameter getParameterByArgument(GrExpression arg) {
        PsiElement parent = PsiUtil.skipParentheses(arg.getParent(), true);
        if (!(parent instanceof GrArgumentList)) {
            return null;
        }
        GrArgumentList argList = (GrArgumentList)parent;
        if (!((parent = parent.getParent()) instanceof GrMethodCall)) {
            return null;
        }
        GrMethodCall methodCall = (GrMethodCall)parent;
        GrExpression expression = methodCall.getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            return null;
        }
        GroovyResolveResult resolveResult = ((GrReferenceExpression)expression).advancedResolve();
        if (resolveResult == null) {
            return null;
        }
        GrClosableBlock[] closures = methodCall.getClosureArguments();
        Map<GrExpression, Pair<PsiParameter, PsiType>> mapToParams = GrClosureSignatureUtil.mapArgumentsToParameters(resolveResult, arg, false, false, argList.getNamedArguments(), argList.getExpressionArguments(), closures);
        if (mapToParams == null) {
            return null;
        }
        Pair<PsiParameter, PsiType> parameterPair = mapToParams.get(arg);
        PsiParameter parameter = parameterPair == null ? null : (PsiParameter)parameterPair.getFirst();
        return parameter instanceof GrParameter ? (GrParameter)parameter : null;
    }

    @Nullable
    public static GrParameter checkForMethodParameter(GrExpression map) {
        GrParameter parameter = ConvertMapToClassIntention.getParameterByArgument(map);
        if (parameter == null) {
            return null;
        }
        PsiElement parent = parameter.getParent().getParent();
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)parent;
        if (ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((Project)map.getProject(), (String)GroovyIntentionsBundle.message("do.you.want.to.change.type.of.parameter.in.method", parameter.getName(), method.getName()), (String)GroovyIntentionsBundle.message("convert.map.to.class.intention.name", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            return parameter;
        }
        return null;
    }

    public static GrTypeDefinition createClass(Project project, GrNamedArgument[] namedArguments, String packageName, String className) {
        StringBuilder classText = new StringBuilder();
        if (!packageName.isEmpty()) {
            classText.append("package ").append(packageName).append('\n');
        }
        classText.append("class ").append(className).append(" {\n");
        for (GrNamedArgument argument : namedArguments) {
            String fieldName = argument.getLabelName();
            GrExpression expression = argument.getExpression();
            LOG.assertTrue(expression != null);
            PsiType type = TypesUtil.unboxPrimitiveTypeWrapper(expression.getType());
            if (type != null) {
                classText.append(type.getCanonicalText());
            } else {
                classText.append("def");
            }
            classText.append(' ').append(fieldName).append('\n');
        }
        classText.append('}');
        return GroovyPsiElementFactory.getInstance(project).createTypeDefinition(classText.toString());
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MyPredicate();
    }
}

