/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ConvertMethodToClosureIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.intentions.conversions.ConvertMethodToclosureIntention");

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MyPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrMethod method;
        MultiMap conflicts = new MultiMap();
        if (element.getParent() instanceof GrMethod) {
            method = (GrMethod)element.getParent();
        } else {
            PsiReference ref = element.getReference();
            LOG.assertTrue(ref != null);
            PsiElement resolved = ref.resolve();
            LOG.assertTrue(resolved instanceof GrMethod);
            method = (GrMethod)resolved;
        }
        PsiClass containingClass = method.getContainingClass();
        String methodName = method.getName();
        PsiField field = containingClass.findFieldByName(methodName, true);
        if (field != null) {
            conflicts.putValue((Object)field, (Object)GroovyIntentionsBundle.message("field.already.exists", methodName));
        }
        Collection references = MethodReferencesSearch.search((PsiMethod)method).findAll();
        HashSet usagesToConvert = new HashSet(references.size());
        for (PsiReference ref : references) {
            PsiElement psiElement = ref.getElement();
            if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(psiElement.getLanguage())) {
                conflicts.putValue((Object)psiElement, (Object)GroovyIntentionsBundle.message("method.is.used.outside.of.groovy", new Object[0]));
                continue;
            }
            if (PsiUtil.isMethodUsage(psiElement) || !(psiElement instanceof GrReferenceExpression) || !((GrReferenceExpression)psiElement).hasMemberPointer()) continue;
            usagesToConvert.add((GrReferenceExpression)psiElement);
        }
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts, () -> ConvertMethodToClosureIntention.lambda$processIntention$0(method, (Collection)usagesToConvert));
            conflictsDialog.show();
            if (conflictsDialog.getExitCode() != 0) {
                return;
            }
        }
        ConvertMethodToClosureIntention.execute(method, (Collection<GrReferenceExpression>)usagesToConvert);
    }

    private static void execute(GrMethod method, Collection<GrReferenceExpression> usagesToConvert) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(method.getProject());
            StringBuilder builder = new StringBuilder(method.getTextLength());
            String modifiers = method.getModifierList().getText();
            if (modifiers.trim().isEmpty()) {
                modifiers = "def";
            }
            builder.append(modifiers).append(' ');
            builder.append(method.getName()).append("={");
            builder.append(method.getParameterList().getText()).append(" ->");
            GrOpenBlock block = method.getBlock();
            builder.append(block.getText().substring(1));
            GrVariableDeclaration variableDeclaration = GroovyPsiElementFactory.getInstance(method.getProject()).createFieldDeclarationFromText(builder.toString());
            method.replace(variableDeclaration);
            for (GrReferenceExpression element : usagesToConvert) {
                PsiElement qualifier = element.getQualifier();
                StringBuilder text = new StringBuilder(qualifier.getText());
                element.setQualifier(null);
                text.append('.').append(element.getText());
                element.replace(factory.createExpressionFromText(text.toString()));
            }
        });
    }

    private static /* synthetic */ void lambda$processIntention$0(GrMethod method, Collection usagesToConvert) {
        ConvertMethodToClosureIntention.execute(method, usagesToConvert);
    }

    private static class MyPredicate
    implements PsiElementPredicate {
        private MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            GrMethod method;
            if (element.getLanguage() != GroovyLanguage.INSTANCE) {
                return false;
            }
            PsiReference ref = element.getReference();
            if (ref != null) {
                PsiElement resolved = ref.resolve();
                if (!(resolved instanceof GrMethod)) {
                    return false;
                }
                method = (GrMethod)resolved;
            } else {
                PsiElement parent = element.getParent();
                if (!(parent instanceof GrMethod)) {
                    return false;
                }
                if (((GrMethod)parent).getNameIdentifierGroovy() != element) {
                    return false;
                }
                method = (GrMethod)parent;
            }
            return method.getBlock() != null && method.getParent() instanceof GrTypeDefinitionBody;
        }
    }
}

