/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.other;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GrCopyStringConcatenationContentIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        StringBuilder buffer = new StringBuilder();
        GrCopyStringConcatenationContentIntention.getValue(element, buffer);
        StringSelection contents = new StringSelection(buffer.toString());
        CopyPasteManager.getInstance().setContents((Transferable)contents);
    }

    private static void getValue(PsiElement element, StringBuilder buffer) {
        if (element instanceof GrLiteral) {
            buffer.append(((GrLiteral)element).getValue());
        } else if (element instanceof GrBinaryExpression) {
            GrCopyStringConcatenationContentIntention.getValue(((GrBinaryExpression)element).getLeftOperand(), buffer);
            GrCopyStringConcatenationContentIntention.getValue(((GrBinaryExpression)element).getRightOperand(), buffer);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (element instanceof GrLiteral && ((GrLiteral)element).getValue() instanceof String) {
                    return true;
                }
                return element instanceof GrBinaryExpression && ((GrBinaryExpression)element).getOperationTokenType() == GroovyTokenTypes.mPLUS && this.satisfiedBy(((GrBinaryExpression)element).getLeftOperand()) && this.satisfiedBy(((GrBinaryExpression)element).getRightOperand());
            }
        };
    }
}

