/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;

public class AnnotationAttributeCompletionResultProcessor {
    private final GrAnnotation myAnnotation;

    public AnnotationAttributeCompletionResultProcessor(@NotNull GrAnnotation annotation) {
        this.myAnnotation = annotation;
    }

    public void process(@NotNull Consumer<LookupElement> consumer, @NotNull PrefixMatcher matcher) {
        block5: {
            PsiElement resolved;
            block6: {
                GrCodeReferenceElement ref = this.myAnnotation.getClassReference();
                resolved = ref.resolve();
                if (!(resolved instanceof PsiClass)) break block5;
                PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved);
                if (annotationCollector == null) break block6;
                ArrayList annotations = ContainerUtil.newArrayList();
                GrAnnotationCollector.collectAnnotations(annotations, this.myAnnotation, annotationCollector);
                HashSet usedNames = ContainerUtil.newHashSet();
                for (GrAnnotation annotation : annotations) {
                    PsiElement resolvedAliased = annotation.getClassReference().resolve();
                    if (!(resolvedAliased instanceof PsiClass) || !((PsiClass)resolvedAliased).isAnnotationType()) continue;
                    for (PsiMethod method : ((PsiClass)resolvedAliased).getMethods()) {
                        if (!usedNames.add(method.getName())) continue;
                        for (LookupElement lookupElement : GroovyCompletionUtil.createLookupElements(new GroovyResolveResultImpl((PsiElement)method, true), false, matcher, null)) {
                            consumer.consume((Object)lookupElement);
                        }
                    }
                }
                break block5;
            }
            if (!((PsiClass)resolved).isAnnotationType()) break block5;
            for (PsiMethod method : ((PsiClass)resolved).getMethods()) {
                for (LookupElement lookupElement : GroovyCompletionUtil.createLookupElements(new GroovyResolveResultImpl((PsiElement)method, true), false, matcher, null)) {
                    consumer.consume((Object)lookupElement);
                }
            }
        }
    }
}

