/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.types.GrCodeReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CompletionProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class CompleteCodeReferenceElement {
    private static final Logger LOG = Logger.getInstance(CompleteCodeReferenceElement.class);
    private final GrCodeReferenceElementImpl myRef;
    private final Consumer<LookupElement> myConsumer;
    private final PrefixMatcher myMatcher;

    private CompleteCodeReferenceElement(@NotNull GrCodeReferenceElementImpl ref, @NotNull Consumer<LookupElement> consumer, @NotNull PrefixMatcher matcher) {
        this.myRef = ref;
        this.myConsumer = consumer;
        this.myMatcher = matcher;
    }

    public static void processVariants(@NotNull GrCodeReferenceElementImpl ref, @NotNull Consumer<LookupElement> consumer, @NotNull PrefixMatcher matcher) {
        new CompleteCodeReferenceElement(ref, consumer, matcher).processVariantsImpl();
    }

    private void feedLookupElements(@NotNull PsiNamedElement psi, boolean afterNew) {
        GroovyResolveResultImpl candidate = new GroovyResolveResultImpl((PsiElement)psi, true);
        List<? extends LookupElement> elements = GroovyCompletionUtil.createLookupElements(candidate, afterNew, this.myMatcher, null);
        for (LookupElement lookupElement : elements) {
            this.myConsumer.consume((Object)lookupElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processVariantsImpl() {
        boolean afterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)this.myRef);
        switch (this.myRef.getKind(true)) {
            case STATIC_MEMBER_FQ: {
                PsiElement resolve;
                GrCodeReferenceElement qualifier = this.myRef.getQualifier();
                if (qualifier != null && (resolve = qualifier.resolve()) instanceof PsiClass) {
                    PsiClass clazz = (PsiClass)resolve;
                    for (PsiField psiField : clazz.getFields()) {
                        if (!psiField.hasModifierProperty("static")) continue;
                        this.feedLookupElements((PsiNamedElement)psiField, afterNew);
                    }
                    for (PsiField psiField : clazz.getMethods()) {
                        if (!psiField.hasModifierProperty("static")) continue;
                        this.feedLookupElements((PsiNamedElement)psiField, afterNew);
                    }
                    for (PsiField psiField : clazz.getInnerClasses()) {
                        if (!psiField.hasModifierProperty("static")) continue;
                        this.feedLookupElements((PsiNamedElement)psiField, afterNew);
                    }
                    return;
                }
            }
            case PACKAGE_FQ: 
            case CLASS_FQ: 
            case CLASS_OR_PACKAGE_FQ: {
                String refText = PsiUtil.getQualifiedReferenceText(this.myRef);
                LOG.assertTrue(refText != null, (Object)this.myRef.getText());
                String parentPackageFQName = StringUtil.getPackageName((String)refText);
                PsiPackage parentPackage = JavaPsiFacade.getInstance((Project)this.myRef.getProject()).findPackage(parentPackageFQName);
                if (parentPackage != null) {
                    void var8_35;
                    void var8_33;
                    GlobalSearchScope scope = this.myRef.getResolveScope();
                    if (this.myRef.getKind(true) == GrCodeReferenceElementImpl.ReferenceKind.PACKAGE_FQ) {
                        void var8_29;
                        PsiPackage[] psiPackageArray = parentPackage.getSubPackages(scope);
                        int n = psiPackageArray.length;
                        boolean bl = false;
                        while (var8_29 < n) {
                            PsiPackage psiPackage = psiPackageArray[var8_29];
                            this.feedLookupElements((PsiNamedElement)psiPackage, afterNew);
                            ++var8_29;
                        }
                        return;
                    }
                    if (this.myRef.getKind(true) == GrCodeReferenceElementImpl.ReferenceKind.CLASS_FQ) {
                        void var8_31;
                        PsiClass[] psiClassArray = parentPackage.getClasses(scope);
                        int n = psiClassArray.length;
                        boolean bl = false;
                        while (var8_31 < n) {
                            PsiClass psiClass = psiClassArray[var8_31];
                            this.feedLookupElements((PsiNamedElement)psiClass, afterNew);
                            ++var8_31;
                        }
                        return;
                    }
                    PsiPackage[] psiPackageArray = parentPackage.getSubPackages(scope);
                    int n = psiPackageArray.length;
                    boolean bl = false;
                    while (var8_33 < n) {
                        PsiPackage psiPackage = psiPackageArray[var8_33];
                        this.feedLookupElements((PsiNamedElement)psiPackage, afterNew);
                        ++var8_33;
                    }
                    psiPackageArray = parentPackage.getClasses(scope);
                    n = psiPackageArray.length;
                    boolean bl2 = false;
                    while (var8_35 < n) {
                        PsiPackage psiPackage = psiPackageArray[var8_35];
                        this.feedLookupElements((PsiNamedElement)psiPackage, afterNew);
                        ++var8_35;
                    }
                    return;
                }
            }
            case CLASS_OR_PACKAGE: 
            case CLASS: {
                GrCodeReferenceElement qualifier = this.myRef.getQualifier();
                if (qualifier != null) {
                    PsiElement qualifierResolved = qualifier.resolve();
                    if (qualifierResolved instanceof PsiPackage) {
                        PsiPackage aPackage = (PsiPackage)qualifierResolved;
                        for (PsiClass psiClass : aPackage.getClasses(this.myRef.getResolveScope())) {
                            this.feedLookupElements((PsiNamedElement)psiClass, afterNew);
                        }
                        if (this.myRef.getKind(true) == GrCodeReferenceElementImpl.ReferenceKind.CLASS) {
                            return;
                        }
                        for (PsiClass psiClass : aPackage.getSubPackages(this.myRef.getResolveScope())) {
                            this.feedLookupElements((PsiNamedElement)psiClass, afterNew);
                        }
                    } else {
                        if (!(qualifierResolved instanceof PsiClass)) break;
                        for (PsiClass aClass : ((PsiClass)qualifierResolved).getInnerClasses()) {
                            this.feedLookupElements((PsiNamedElement)aClass, afterNew);
                        }
                    }
                } else {
                    ResolverProcessor classProcessor = CompletionProcessor.createClassCompletionProcessor(this.myRef);
                    this.processTypeParametersFromUnfinishedMethodOrField(classProcessor);
                    PsiTreeUtilKt.treeWalkUp(this.myRef, classProcessor);
                    for (LookupElement o : GroovyCompletionUtil.getCompletionVariants(classProcessor.getCandidates(), afterNew, this.myMatcher, (PsiElement)this.myRef)) {
                        this.myConsumer.consume((Object)o);
                    }
                }
                break;
            }
        }
    }

    private void processTypeParametersFromUnfinishedMethodOrField(@NotNull ResolverProcessor processor) {
        PsiElement candidate = this.findTypeParameterListCandidate();
        if (candidate instanceof GrTypeParameterList) {
            for (GrTypeParameter p : ((GrTypeParameterList)candidate).getTypeParameters()) {
                ResolveUtil.processElement(processor, p, ResolveState.initial());
            }
        }
    }

    @Nullable
    private PsiElement findTypeParameterListCandidate() {
        PsiElement errorElement;
        GrTypeElement typeElement = this.getRootTypeElement();
        if (typeElement == null) {
            return null;
        }
        if (typeElement.getParent() instanceof GrTypeDefinitionBody) {
            return PsiUtil.skipWhitespacesAndComments(typeElement.getPrevSibling(), false);
        }
        if (typeElement.getParent() instanceof GrVariableDeclaration && (errorElement = PsiUtil.skipWhitespacesAndComments(typeElement.getPrevSibling(), false)) instanceof PsiErrorElement) {
            return errorElement.getFirstChild();
        }
        return null;
    }

    @Nullable
    private GrTypeElement getRootTypeElement() {
        PsiElement parent = this.myRef.getParent();
        while (CompleteCodeReferenceElement.isTypeElementChild(parent)) {
            if (parent instanceof GrTypeElement && !CompleteCodeReferenceElement.isTypeElementChild(parent.getParent())) {
                return (GrTypeElement)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static boolean isTypeElementChild(@Nullable PsiElement element) {
        return element instanceof GrCodeReferenceElement || element instanceof GrTypeArgumentList || element instanceof GrTypeElement;
    }
}

