/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class CompleteReferencesWithSameQualifier {
    private final GrReferenceExpression myRefExpr;
    private final PrefixMatcher myMatcher;
    private final GrExpression myQualifier;

    private CompleteReferencesWithSameQualifier(@NotNull GrReferenceExpression refExpr, @NotNull PrefixMatcher matcher, @Nullable GrExpression qualifier) {
        this.myRefExpr = refExpr;
        this.myMatcher = matcher;
        this.myQualifier = qualifier;
    }

    @NotNull
    public static Set<String> getVariantsWithSameQualifier(@NotNull GrReferenceExpression refExpr, @NotNull PrefixMatcher matcher, @Nullable GrExpression qualifier) {
        return new CompleteReferencesWithSameQualifier(refExpr, matcher, qualifier).getVariantsWithSameQualifierImpl();
    }

    private Set<String> getVariantsWithSameQualifierImpl() {
        if (this.myQualifier != null && this.myQualifier.getType() != null) {
            return Collections.emptySet();
        }
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, (Class[])new Class[]{GrMember.class, PsiFile.class});
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        if (scope != null) {
            this.addVariantsWithSameQualifier(scope, result);
        }
        return result;
    }

    private void addVariantsWithSameQualifier(@NotNull PsiElement element, @NotNull Set<String> result) {
        GrReferenceExpression refExpr;
        String refName;
        if (element instanceof GrReferenceExpression && element != this.myRefExpr && !PsiUtil.isLValue((GroovyPsiElement)element) && (refName = (refExpr = (GrReferenceExpression)element).getReferenceName()) != null && !result.contains(refName) && this.myMatcher.prefixMatches(refName)) {
            GrExpression hisQualifier = refExpr.getQualifierExpression();
            if (hisQualifier != null && this.myQualifier != null) {
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)hisQualifier, (PsiElement)this.myQualifier) && refExpr.resolve() == null) {
                    result.add(refName);
                }
            } else if (hisQualifier == null && this.myQualifier == null && refExpr.resolve() == null) {
                result.add(refName);
            }
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.addVariantsWithSameQualifier(child, result);
        }
    }
}

