/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.completion.MapArgumentCompletionProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovyReferenceCharFilter
extends CharFilter {
    @Nullable
    public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup) {
        PsiFile psiFile = lookup.getPsiFile();
        if (psiFile != null && !psiFile.getViewProvider().getLanguages().contains((Object)GroovyLanguage.INSTANCE)) {
            return null;
        }
        LookupElement item = lookup.getCurrentItem();
        if (item == null) {
            return null;
        }
        if (Character.isJavaIdentifierPart(c) || c == '\'') {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        int caret = lookup.getEditor().getCaretModel().getOffset();
        if (c == '.' && prefixLength == 0 && !lookup.isSelectionTouched() && caret > 0 && lookup.getEditor().getDocument().getCharsSequence().charAt(caret - 1) == '.') {
            return CharFilter.Result.HIDE_LOOKUP;
        }
        if (c == ':') {
            PsiFile file = lookup.getPsiFile();
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(lookup.getEditor().getDocument());
            PsiElement element = file.findElementAt(Math.max(caret - 1, 0));
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(GrReferenceExpression.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(GrCaseLabel.class), PsiJavaPatterns.psiElement(GrConditionalExpression.class)})))).accepts((Object)element)) {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            if (item.getObject() instanceof NamedArgumentDescriptor && (MapArgumentCompletionProvider.IN_ARGUMENT_LIST_OF_CALL.accepts((Object)element) || MapArgumentCompletionProvider.IN_LABEL.accepts((Object)element))) {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            return CharFilter.Result.HIDE_LOOKUP;
        }
        if (c == '[' || c == ']' || c == ')' || c == '>') {
            return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
        }
        if (c == '<' && item.getObject() instanceof PsiClass) {
            return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
        }
        if (c == '(' && "return".equals(item.getLookupString())) {
            return CharFilter.Result.HIDE_LOOKUP;
        }
        return null;
    }
}

