/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GrMethodCallWithSingleClosureArgFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        PsiElement parent = psiElement.getParent();
        if (parent instanceof GrReferenceExpression && !(parent.getParent() instanceof GrMethodCall) && GrMethodCallWithSingleClosureArgFixer.hasOnlyClosureParam((GrReferenceExpression)parent)) {
            int endOffset = psiElement.getTextRange().getEndOffset();
            editor.getDocument().insertString(endOffset, (CharSequence)"{\n}");
        }
    }

    private static boolean hasOnlyClosureParam(GrReferenceExpression ref) {
        GroovyResolveResult[] results2;
        if (ref.resolve() != null) {
            return false;
        }
        for (GroovyResolveResult result : results2 = ref.multiResolve(true)) {
            PsiParameter[] parameters;
            PsiElement element = result.getElement();
            if (!(element instanceof PsiMethod) || (parameters = ((PsiMethod)element).getParameterList().getParameters()).length != 1 || !parameters[0].getType().equalsToText("groovy.lang.Closure")) continue;
            return true;
        }
        return false;
    }
}

