/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

public class ConditionInstruction
extends InstructionImpl
implements Instruction {
    private final Set<ConditionInstruction> myDependent;

    public ConditionInstruction(@NotNull PsiElement element, @NotNull Collection<ConditionInstruction> dependent) {
        super(element);
        this.myDependent = new LinkedHashSet<ConditionInstruction>(dependent);
        this.myDependent.add(this);
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("Condition ").append(this.getElement());
        if (this.myDependent.size() > 1) {
            builder.append(", dependent: ");
            builder.append(StringUtil.join((Collection)ContainerUtil.filter(this.myDependent, d -> d != this), i -> String.valueOf(i.num()), (String)", "));
        }
        return builder.toString();
    }

    public Set<ConditionInstruction> getDependentConditions() {
        return this.myDependent;
    }
}

