/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.LazyFqnClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class GrLiteralClassType
extends PsiClassType {
    protected final GlobalSearchScope myScope;
    protected final JavaPsiFacade myFacade;
    private final GroovyPsiManager myGroovyPsiManager;

    public GrLiteralClassType(LanguageLevel languageLevel, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade) {
        super(languageLevel);
        this.myScope = scope;
        this.myFacade = facade;
        this.myGroovyPsiManager = GroovyPsiManager.getInstance(this.myFacade.getProject());
    }

    @NotNull
    protected abstract String getJavaClassName();

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        return new PsiClassType.ClassResolveResult(){
            private final PsiClass myBaseClass;
            private final NotNullLazyValue<PsiSubstitutor> mySubstitutor;
            {
                this.myBaseClass = GrLiteralClassType.this.resolve();
                this.mySubstitutor = new NotNullLazyValue<PsiSubstitutor>(){

                    @NotNull
                    protected PsiSubstitutor compute() {
                        return GrLiteralClassType.this.inferSubstitutor(myBaseClass);
                    }
                };
            }

            public PsiClass getElement() {
                return this.myBaseClass;
            }

            @NotNull
            public PsiSubstitutor getSubstitutor() {
                return (PsiSubstitutor)this.mySubstitutor.getValue();
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                return true;
            }

            public boolean isStaticsScopeCorrect() {
                return true;
            }

            @Nullable
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }
        };
    }

    @NotNull
    private PsiSubstitutor inferSubstitutor(@Nullable PsiClass myBaseClass) {
        if (myBaseClass != null) {
            PsiType[] typeArgs = this.getParameters();
            PsiTypeParameter[] typeParams = myBaseClass.getTypeParameters();
            if (typeParams.length == typeArgs.length) {
                return PsiSubstitutor.EMPTY.putAll(myBaseClass, typeArgs);
            }
            return PsiSubstitutor.EMPTY.putAll(myBaseClass, GrLiteralClassType.createArray((int)typeParams.length));
        }
        return PsiSubstitutor.EMPTY;
    }

    @NotNull
    public abstract String getClassName();

    @NotNull
    public String getPresentableText() {
        String name = this.getClassName();
        Object[] params = this.getParameters();
        if (params.length == 0 || params[0] == null) {
            return name;
        }
        return name + "<" + StringUtil.join((Object[])params, psiType -> psiType.getPresentableText(), (String)", ") + ">";
    }

    @NotNull
    public String getCanonicalText() {
        String name = this.getJavaClassName();
        Object[] params = this.getParameters();
        if (params.length == 0 || params[0] == null) {
            return name;
        }
        Function f = psiType -> psiType.getCanonicalText();
        return name + "<" + StringUtil.join((Object[])params, (Function)f, (String)", ") + ">";
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    @NotNull
    public GlobalSearchScope getScope() {
        return this.myScope;
    }

    @Nullable
    public PsiClass resolve() {
        return this.myFacade.findClass(this.getJavaClassName(), this.getResolveScope());
    }

    @NotNull
    public PsiClassType rawType() {
        return this.myGroovyPsiManager.createTypeByFQClassName(this.getJavaClassName(), this.myScope);
    }

    public boolean equalsToText(@NotNull @NonNls String text) {
        return text.equals(this.getJavaClassName());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myScope;
    }

    protected static String getInternalCanonicalText(@Nullable PsiType type) {
        return type == null ? "java.lang.Object" : type.getInternalCanonicalText();
    }

    @NotNull
    protected PsiType getLeastUpperBound(PsiType ... psiTypes) {
        PsiType result = null;
        PsiManager manager = this.getPsiManager();
        for (PsiType other : psiTypes) {
            result = TypesUtil.getLeastUpperBoundNullable(result, other, manager);
        }
        return result == null ? LazyFqnClassType.getLazyType("java.lang.Object", this.getLanguageLevel(), this.getResolveScope(), this.myFacade) : result;
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myFacade.getProject());
    }
}

