/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyImportHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.resolve.ImplicitImportsKt;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.PackageSkippingProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;

public class GroovyFileImpl
extends GroovyFileBaseImpl
implements GroovyFile,
PsiModifiableCodeBlock {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl");
    private static final String SYNTHETIC_PARAMETER_NAME = "args";
    private static final CachedValueProvider<ConcurrentMap<String, GrBindingVariable>> BINDING_PROVIDER = () -> {
        ConcurrentMap map = ContainerUtil.newConcurrentMap();
        return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    };
    private volatile Boolean myScript;
    private volatile GroovyScriptClass myScriptClass;
    private volatile GrParameter mySyntheticArgsParameter;
    private volatile PsiElement myContext;
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;

    public GroovyFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, GroovyLanguage.INSTANCE);
        this.myResolveCache = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.buildDeclarationCache(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}), false);
    }

    @Override
    @NotNull
    public String getPackageName() {
        String name;
        GrPackageDefinition packageDef = this.getPackageDefinition();
        if (packageDef != null && (name = packageDef.getPackageName()) != null) {
            return name;
        }
        return "";
    }

    @Override
    public GrPackageDefinition getPackageDefinition() {
        StubElement stub = this.getStub();
        if (stub != null) {
            for (StubElement element : stub.getChildrenStubs()) {
                if (!(element instanceof GrPackageDefinitionStub)) continue;
                return (GrPackageDefinition)element.getPsi();
            }
            return null;
        }
        ASTNode node = this.calcTreeElement().findChildByType((IElementType)GroovyElementTypes.PACKAGE_DEFINITION);
        return node != null ? (GrPackageDefinition)node.getPsi() : null;
    }

    private GrParameter getSyntheticArgsParameter() {
        GrParameter parameter = this.mySyntheticArgsParameter;
        if (parameter == null) {
            PsiType psiType = JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeFromText("java.lang.String[]", (PsiElement)this);
            this.mySyntheticArgsParameter = parameter = new GrLightParameter(SYNTHETIC_PARAMETER_NAME, psiType, this);
        }
        return parameter;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (this.isPhysical() && !this.isScript() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue())) {
            return GroovyFileImpl.processCachedDeclarations(processor, state, (MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>)((MostlySingularMultiMap)this.myResolveCache.getValue()));
        }
        return this.processDeclarationsNoGuess(processor, state, lastParent, place);
    }

    private static boolean processCachedDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> cache) {
        for (PsiScopeProcessor each : GroovyResolverProcessor.allProcessors(processor)) {
            String name = ResolveUtil.getNameHint(each);
            Processor cacheProcessor = res -> each.execute((PsiElement)res.getElement(), state.put(ClassHint.RESOLVE_CONTEXT, (Object)res.getFileContext()));
            boolean result = name != null ? cache.processForKey((Object)name, cacheProcessor) : cache.processAllValues(cacheProcessor);
            if (result) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> buildDeclarationCache() {
        final MostlySingularMultiMap results2 = new MostlySingularMultiMap();
        this.processDeclarationsNoGuess((PsiScopeProcessor)new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                PsiElement context;
                String name;
                if (element instanceof PsiNamedElement && (name = this.getDeclarationName((PsiNamedElement)element, context = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT))) != null) {
                    results2.add((Object)name, (Object)new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)element, context));
                }
                return true;
            }

            private String getDeclarationName(@NotNull PsiNamedElement element, @Nullable PsiElement context) {
                String name = context instanceof GrImportStatement ? ((GrImportStatement)context).getImportedName() : null;
                return name != null ? name : element.getName();
            }
        }, ResolveState.initial(), null, this);
        return results2;
    }

    private boolean processDeclarationsNoGuess(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (this.myContext != null) {
            return !ResolveUtil.shouldProcessProperties(classHint) || this.processChildrenScopes(processor, state, lastParent, place);
        }
        boolean processClasses = ResolveUtil.shouldProcessClasses(classHint);
        GrImportStatement[] importStatements = this.getImportStatements();
        if (!this.processImports(processor, state, lastParent, place, importStatements, GroovyImportHelper.ImportKind.ALIAS, false)) {
            return false;
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null && StringUtil.isJavaIdentifier((String)scriptClass.getName())) {
            if (!(lastParent instanceof GrTypeDefinition) && !ResolveUtil.processClassDeclarations(scriptClass, processor, state, lastParent, place)) {
                return false;
            }
            if (processClasses && !ResolveUtil.processElement(processor, scriptClass, state)) {
                return false;
            }
        }
        if (processClasses) {
            for (GrTypeDefinition definition : this.getTypeDefinitions()) {
                if (ResolveUtil.processElement(processor, definition, state)) continue;
                return false;
            }
        }
        if (ResolveUtil.shouldProcessProperties(classHint) && !this.processChildrenScopes(processor, state, lastParent, place)) {
            return false;
        }
        if (!this.processImports(processor, state, lastParent, place, importStatements, GroovyImportHelper.ImportKind.ALIAS, true)) {
            return false;
        }
        if (!this.processImports(processor, state, lastParent, place, importStatements, GroovyImportHelper.ImportKind.SIMPLE, null)) {
            return false;
        }
        if (!this.processDeclarationsInPackage(processor, state, lastParent, place)) {
            return false;
        }
        if (!this.processImports(processor, state, lastParent, place, importStatements, GroovyImportHelper.ImportKind.ON_DEMAND, null)) {
            return false;
        }
        if (!ImplicitImportsKt.processImplicitImports(processor, state, lastParent, place, this)) {
            return false;
        }
        if (ResolveUtil.shouldProcessPackages(classHint)) {
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String expectedName = nameHint != null ? nameHint.getName(state) : null;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            if (expectedName != null) {
                PsiPackage pkg = facade.findPackage(expectedName);
                if (pkg != null && !processor.execute((PsiElement)pkg, state)) {
                    return false;
                }
            } else {
                PsiPackage defaultPackage = facade.findPackage("");
                if (defaultPackage != null) {
                    for (PsiPackage subPackage : defaultPackage.getSubPackages(this.getResolveScope())) {
                        if (ResolveUtil.processElement(processor, (PsiNamedElement)subPackage, state)) continue;
                        return false;
                    }
                }
            }
        }
        return !ResolveUtil.shouldProcessProperties(classHint) || lastParent == null || lastParent instanceof GrTypeDefinition || scriptClass == null || ResolveUtil.processElement(processor, this.getSyntheticArgsParameter(), state);
    }

    public boolean isInScriptBody(PsiElement lastParent, PsiElement place) {
        return this.isScript() && !(lastParent instanceof GrTypeDefinition) && PsiTreeUtil.getParentOfType((PsiElement)place, GrTypeDefinition.class, (boolean)false) == null;
    }

    protected boolean processImports(PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, @NotNull GrImportStatement[] importStatements, @NotNull GroovyImportHelper.ImportKind kind, @Nullable Boolean processStatic) {
        return GroovyImportHelper.processImports(state, lastParent, place, processor, importStatements, kind, processStatic);
    }

    @NotNull
    public ConcurrentMap<String, GrBindingVariable> getBindings() {
        return (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)this, BINDING_PROVIDER);
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return true;
    }

    private boolean processDeclarationsInPackage(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiPackage aPackage;
        if (ResolveUtil.shouldProcessClasses((ElementClassHint)processor.getHint(ElementClassHint.KEY)) && (aPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(this.getPackageName())) != null) {
            return aPackage.processDeclarations((PsiScopeProcessor)new PackageSkippingProcessor(processor), state, lastParent, place);
        }
        return true;
    }

    private boolean processChildrenScopes(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement run;
        StubElement stub = this.getStub();
        if (stub != null) {
            return true;
        }
        PsiElement psiElement = run = lastParent == null ? this.getLastChild() : lastParent.getPrevSibling();
        while (run != null) {
            if (GroovyFileImpl.shouldProcess(lastParent, run) && !run.processDeclarations(processor, state, null, place)) {
                return false;
            }
            run = run.getPrevSibling();
        }
        return true;
    }

    private static boolean shouldProcess(@Nullable PsiElement lastParent, @NotNull PsiElement run) {
        return run instanceof GrAssignmentExpression || run instanceof GrVariableDeclaration && !(lastParent instanceof GrMember);
    }

    @Override
    public GrImportStatement[] getImportStatements() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (GrImportStatement[])stub.getChildrenByType((IElementType)GroovyElementTypes.IMPORT_STATEMENT, GrImportStatement.ARRAY_FACTORY);
        }
        return (GrImportStatement[])this.calcTreeElement().getChildrenAsPsiElements((IElementType)GroovyElementTypes.IMPORT_STATEMENT, GrImportStatement.ARRAY_FACTORY);
    }

    @Override
    public GrImportStatement addImportForClass(@NotNull PsiClass aClass) {
        try {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String qname = aClass.getQualifiedName();
            if (qname != null) {
                GrImportStatement importStatement = factory.createImportStatementFromText(qname, false, false, null);
                return this.addImport(importStatement);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    @NotNull
    public GrImportStatement addImport(@NotNull GrImportStatement statement) throws IncorrectOperationException {
        return GroovyCodeStyleManager.getInstance(this.getProject()).addImport(this, statement);
    }

    @Override
    public boolean isScript() {
        Boolean isScript = this.myScript;
        if (isScript == null) {
            this.myScript = isScript = Boolean.valueOf(this.checkIsScript());
        }
        return isScript;
    }

    private boolean checkIsScript() {
        GrTopStatement[] topStatements = (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class);
        boolean hasClassDefinitions = false;
        boolean hasTopStatements = false;
        for (GrTopStatement st : topStatements) {
            if (st instanceof GrTypeDefinition) {
                hasClassDefinitions = true;
                continue;
            }
            if (st instanceof GrImportStatement || st instanceof GrPackageDefinition) continue;
            hasTopStatements = true;
            break;
        }
        return hasTopStatements || !hasClassDefinitions;
    }

    public void subtreeChanged() {
        this.myScript = null;
        super.subtreeChanged();
    }

    @Override
    public GroovyScriptClass getScriptClass() {
        if (!this.isScript()) {
            return null;
        }
        GroovyScriptClass aClass = this.myScriptClass;
        if (aClass == null) {
            this.myScriptClass = aClass = new GroovyScriptClass(this);
        }
        return aClass;
    }

    @Override
    public void setPackageName(String packageName) {
        GrCodeReferenceElement packageReference;
        FileASTNode fileNode = this.getNode();
        GrPackageDefinition currentPackage = this.getPackageDefinition();
        if (packageName == null || packageName.isEmpty()) {
            if (currentPackage != null) {
                ASTNode currNode = currentPackage.getNode();
                fileNode.removeChild(currNode);
            }
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GrPackageDefinition newPackage = (GrPackageDefinition)factory.createTopElementFromText("package " + packageName);
        if (currentPackage != null && (packageReference = currentPackage.getPackageReference()) != null) {
            GrCodeReferenceElement ref = newPackage.getPackageReference();
            if (ref != null) {
                packageReference.replace(ref);
            }
            return;
        }
        ASTNode newNode = newPackage.getNode();
        if (currentPackage != null) {
            ASTNode currNode = currentPackage.getNode();
            fileNode.replaceChild(currNode, newNode);
        } else {
            ASTNode anchor = fileNode.getFirstChildNode();
            if (anchor != null && anchor.getElementType() == GroovyTokenTypes.mSH_COMMENT) {
                anchor = anchor.getTreeNext();
                fileNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor);
            }
            fileNode.addChild(newNode, anchor);
            if (anchor != null && !anchor.getText().startsWith("\n\n")) {
                fileNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor);
            }
        }
    }

    @Override
    @Nullable
    public GrPackageDefinition setPackage(@Nullable GrPackageDefinition newPackage) {
        GrPackageDefinition oldPackage = this.getPackageDefinition();
        if (oldPackage == null) {
            if (newPackage != null) {
                GrPackageDefinition result = (GrPackageDefinition)this.addAfter(newPackage, null);
                this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", result.getNode().getTreeNext());
                return result;
            }
        } else {
            if (newPackage != null) {
                return (GrPackageDefinition)oldPackage.replace(newPackage);
            }
            oldPackage.delete();
        }
        return null;
    }

    @Override
    public PsiType getInferredScriptReturnType() {
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)GroovyPsiManager.inferType(this, new MethodTypeInferencer(this)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myScriptClass = null;
        this.mySyntheticArgsParameter = null;
    }

    public PsiElement getContext() {
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    protected GroovyFileImpl clone() {
        GroovyFileImpl clone = (GroovyFileImpl)super.clone();
        clone.myContext = this.myContext;
        return clone;
    }

    public void setContext(PsiElement context) {
        if (context != null) {
            this.myContext = context;
        }
    }

    public void setContextNullable(PsiElement context) {
        this.myContext = context;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] declaredDefs = super.getClasses();
        if (!this.isScript()) {
            return declaredDefs;
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        PsiClass[] result = new PsiClass[declaredDefs.length + 1];
        result[result.length - 1] = scriptClass;
        System.arraycopy(declaredDefs, 0, result, 0, declaredDefs.length);
        return result;
    }

    public PsiElement getOriginalElement() {
        PsiElement originalElement;
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null && (originalElement = scriptClass.getOriginalElement()) != scriptClass && originalElement != null) {
            return originalElement.getContainingFile();
        }
        return this;
    }

    @Override
    @NotNull
    public GrVariableDeclaration[] getScriptDeclarations(boolean topLevelOnly) {
        return PsiImplUtilKt.getScriptDeclarations(this, topLevelOnly);
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        if (!this.isContentsLoaded()) {
            return true;
        }
        return !this.isScript() || PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{GrTypeDefinition.class, GrVariableDeclaration.class}) != null;
    }

    @Override
    public String toString() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return super.toString();
        }
        return "GroovyFileImpl:" + this.getName();
    }
}

