/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.resolve.GrImportContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ImportType;

public class GroovyImportHelper {
    public static boolean isImplicitlyImported(PsiElement element, String expectedName, GroovyFile file) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)element;
        if (!expectedName.equals(psiClass.getName())) {
            return false;
        }
        String qname = psiClass.getQualifiedName();
        if (qname == null) {
            return false;
        }
        for (String importedClass : GroovyFileBase.IMPLICITLY_IMPORTED_CLASSES) {
            if (!qname.equals(importedClass)) continue;
            return true;
        }
        for (String pkg : GroovyImportHelper.getImplicitlyImportedPackages(file)) {
            if (!qname.equals(pkg + "." + expectedName) && (!pkg.isEmpty() || !qname.equals(expectedName))) continue;
            return true;
        }
        return false;
    }

    public static LinkedHashSet<String> getImplicitlyImportedPackages(@NotNull GroovyFile file) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ContainerUtil.addAll(result, (Object[])GroovyFileBase.IMPLICITLY_IMPORTED_PACKAGES);
        for (GrImportContributor contributor : (GrImportContributor[])GrImportContributor.EP_NAME.getExtensions()) {
            result.addAll(ContainerUtil.mapNotNull(contributor.getImports(file), i -> i.getType() == ImportType.STAR ? i.getName() : null));
        }
        return result;
    }

    public static boolean processImports(@NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, @NotNull PsiScopeProcessor importProcessor, @NotNull GrImportStatement[] importStatements, @NotNull ImportKind kind, @Nullable Boolean processStatic) {
        for (int i = importStatements.length - 1; i >= 0; --i) {
            GrImportStatement imp = importStatements[i];
            if (GroovyImportHelper.getImportKind(imp) != kind || processStatic != null && processStatic.booleanValue() != imp.isStatic() || imp.processDeclarations(importProcessor, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static ImportKind getImportKind(GrImportStatement statement) {
        if (statement.isOnDemand() && !statement.isAliasedImport()) {
            return ImportKind.ON_DEMAND;
        }
        if (!statement.isOnDemand() && statement.isAliasedImport()) {
            return ImportKind.ALIAS;
        }
        if (!statement.isAliasedImport() && !statement.isOnDemand()) {
            return ImportKind.SIMPLE;
        }
        return null;
    }

    public static enum ImportKind {
        SIMPLE,
        ON_DEMAND,
        ALIAS;

    }
}

