/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public interface InferenceContext {
    public static final InferenceContext TOP_CONTEXT = new InferenceContext(){

        @Override
        @Nullable
        public PsiType getVariableType(@NotNull GrReferenceExpression ref) {
            return TypeInferenceHelper.getInferredType(ref);
        }

        @Override
        public <T> T getCachedValue(@NotNull GroovyPsiElement element, @NotNull Computable<T> computable) {
            CachedValuesManager manager = CachedValuesManager.getManager((Project)element.getProject());
            Key key = manager.getKeyForClass(computable.getClass());
            return (T)manager.getCachedValue((UserDataHolder)element, key, () -> CachedValueProvider.Result.create((Object)computable.compute(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
        }

        @Override
        public <T extends PsiPolyVariantReference> GroovyResolveResult[] multiResolve(@NotNull T ref, boolean incomplete, @NotNull ResolveCache.PolyVariantResolver<T> resolver) {
            ResolveResult[] results2 = ResolveCache.getInstance((Project)ref.getElement().getProject()).resolveWithCaching(ref, resolver, true, incomplete);
            return results2.length == 0 ? GroovyResolveResult.EMPTY_ARRAY : (GroovyResolveResult[])results2;
        }

        @Override
        @Nullable
        public <T extends GroovyPsiElement> PsiType getExpressionType(@NotNull T element, @NotNull Function<T, PsiType> calculator) {
            return GroovyPsiManager.getInstance(element.getProject()).getType(element, calculator);
        }
    };

    @Nullable
    public PsiType getVariableType(@NotNull GrReferenceExpression var1);

    public <T> T getCachedValue(@NotNull GroovyPsiElement var1, @NotNull Computable<T> var2);

    public <T extends PsiPolyVariantReference> GroovyResolveResult[] multiResolve(@NotNull T var1, boolean var2, @NotNull ResolveCache.PolyVariantResolver<T> var3);

    @Nullable
    public <T extends GroovyPsiElement> PsiType getExpressionType(@NotNull T var1, @NotNull Function<T, PsiType> var2);

    public static class PartialContext
    implements InferenceContext {
        private final Map<String, PsiType> myTypes;
        private final Map<PsiElement, Map<Object, Object>> myCache = ContainerUtil.newHashMap();

        public PartialContext(@NotNull Map<String, PsiType> types) {
            this.myTypes = types;
        }

        @Override
        @Nullable
        public PsiType getVariableType(@NotNull GrReferenceExpression ref) {
            return this.myTypes.get(ref.getReferenceName());
        }

        @Override
        public <T> T getCachedValue(@NotNull GroovyPsiElement element, @NotNull Computable<T> computable) {
            return this._getCachedValue(element, computable, computable.getClass());
        }

        private <T> T _getCachedValue(@Nullable PsiElement element, @NotNull Computable<T> computable, @NotNull Object key) {
            HashMap map = this.myCache.get(element);
            if (map == null) {
                map = ContainerUtil.newHashMap();
                this.myCache.put(element, map);
            }
            if (map.containsKey(key)) {
                return (T)map.get(key);
            }
            Object result = computable.compute();
            map.put(key, result);
            return (T)result;
        }

        @Override
        @NotNull
        public <T extends PsiPolyVariantReference> GroovyResolveResult[] multiResolve(@NotNull T ref, boolean incomplete, @NotNull ResolveCache.PolyVariantResolver<T> resolver) {
            return (GroovyResolveResult[])this._getCachedValue(ref.getElement(), () -> {
                Pair key = Pair.create((Object)ref, (Object)incomplete);
                GroovyResolveResult[] results2 = (GroovyResolveResult[])RecursionManager.doPreventingRecursion((Object)key, (boolean)true, () -> (GroovyResolveResult[])resolver.resolve(ref, incomplete));
                return results2 == null ? GroovyResolveResult.EMPTY_ARRAY : results2;
            }, Pair.create((Object)incomplete, resolver.getClass()));
        }

        @Override
        @Nullable
        public <T extends GroovyPsiElement> PsiType getExpressionType(@NotNull T element, @NotNull Function<T, PsiType> calculator) {
            return (PsiType)this._getCachedValue(element, () -> (PsiType)calculator.fun((Object)element), "type");
        }
    }
}

