/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;

public class GrAnnotationCollector {
    @NotNull
    public static GrAnnotation[] getResolvedAnnotations(@NotNull GrModifierList modifierList) {
        GrAnnotation[] rawAnnotations = modifierList.getRawAnnotations();
        if (!GrAnnotationCollector.hasAliases(rawAnnotations)) {
            return rawAnnotations;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (GrAnnotation annotation : rawAnnotations) {
            PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
            if (annotationCollector != null) {
                GrAnnotationCollector.collectAnnotations(result, annotation, annotationCollector);
                continue;
            }
            result.add(annotation);
        }
        return result.toArray(new GrAnnotation[result.size()]);
    }

    private static boolean hasAliases(@NotNull GrAnnotation[] rawAnnotations) {
        for (GrAnnotation annotation : rawAnnotations) {
            PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
            if (annotationCollector == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<String> collectAnnotations(@NotNull List<GrAnnotation> list, @NotNull GrAnnotation alias, @NotNull PsiAnnotation annotationCollector) {
        PsiModifierList modifierList = (PsiModifierList)annotationCollector.getParent();
        LinkedHashMap annotations = ContainerUtil.newLinkedHashMap();
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(annotationCollector, annotations);
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorAnnotations(modifierList, annotations);
        PsiManager manager = alias.getManager();
        GrAnnotationNameValuePair[] attributes = alias.getParameterList().getAttributes();
        LinkedHashSet allUsedAttrs = ContainerUtil.newLinkedHashSet();
        for (Map.Entry entry : annotations.entrySet()) {
            String qname = (String)entry.getKey();
            PsiClass resolved = JavaPsiFacade.getInstance((Project)alias.getProject()).findClass(qname, alias.getResolveScope());
            if (resolved == null) continue;
            GrLightAnnotation annotation = new GrLightAnnotation(manager, alias.getLanguage(), qname, (PsiAnnotationOwner)modifierList);
            LinkedHashSet usedAttrs = ContainerUtil.newLinkedHashSet();
            for (GrAnnotationNameValuePair attr : attributes) {
                String name;
                String string = name = attr.getName() != null ? attr.getName() : "value";
                if (resolved.findMethodsByName(name, false).length <= 0) continue;
                annotation.addAttribute(attr);
                allUsedAttrs.add(name);
                usedAttrs.add(name);
            }
            Map defaults = (Map)entry.getValue();
            for (Map.Entry defa : defaults.entrySet()) {
                if (usedAttrs.contains(defa.getKey())) continue;
                annotation.addAttribute((PsiNameValuePair)defa.getValue());
            }
            list.add(annotation);
        }
        return allUsedAttrs;
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorAnnotations(@NotNull PsiModifierList modifierList, @NotNull Map<String, Map<String, PsiNameValuePair>> annotations) {
        PsiAnnotation[] rawAnnotations;
        PsiElement parent = modifierList.getParent();
        if (parent instanceof PsiClass && "groovy.transform.CompileDynamic".equals(((PsiClass)parent).getQualifiedName())) {
            LinkedHashMap params = ContainerUtil.newLinkedHashMap();
            annotations.put("groovy.transform.CompileStatic", params);
            GrAnnotation annotation = GroovyPsiElementFactory.getInstance(modifierList.getProject()).createAnnotationFromText("@CompileStatic(TypeCheckingMode.SKIP)");
            params.put("value", annotation.getParameterList().getAttributes()[0]);
            return;
        }
        for (PsiAnnotation annotation : rawAnnotations = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
            PsiNameValuePair[] attributes;
            String qname = annotation.getQualifiedName();
            if (qname == null || qname.equals("groovy.transform.AnnotationCollector")) continue;
            for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
                LinkedHashMap map = annotations.get(qname);
                if (map == null) {
                    map = ContainerUtil.newLinkedHashMap();
                    annotations.put(qname, map);
                }
                map.put(pair.getName() != null ? pair.getName() : "value", pair);
            }
            if (attributes.length != 0 || annotations.containsKey(qname)) continue;
            annotations.put(qname, ContainerUtil.newLinkedHashMap());
        }
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(@NotNull PsiAnnotation annotationCollector, @NotNull Map<String, Map<String, PsiNameValuePair>> annotations) {
        PsiAnnotationMemberValue annotationsFromValue = annotationCollector.findAttributeValue("value");
        if (annotationsFromValue instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue member : ((GrAnnotationArrayInitializer)annotationsFromValue).getInitializers()) {
                PsiElement resolved;
                if (!(member instanceof GrReferenceExpression) || !((resolved = ((GrReferenceExpression)member).resolve()) instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                annotations.put(((PsiClass)resolved).getQualifiedName(), ContainerUtil.newLinkedHashMap());
            }
        }
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@Nullable PsiClass clazz) {
        PsiModifierList modifierList;
        if (clazz != null && (modifierList = clazz.getModifierList()) != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
                if (!"groovy.transform.AnnotationCollector".equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@NotNull GrAnnotation annotation) {
        GrCodeReferenceElement ref = annotation.getClassReference();
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiClass) {
            return GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved);
        }
        return null;
    }
}

