/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignatureVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;

class GrClosableSignatureImpl
implements GrClosureSignature {
    private final GrClosableBlock myBlock;

    public GrClosableSignatureImpl(GrClosableBlock block) {
        this.myBlock = block;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        return PsiSubstitutor.EMPTY;
    }

    @Override
    @NotNull
    public GrClosureParameter[] getParameters() {
        Object[] parameters = this.myBlock.getAllParameters();
        return (GrClosureParameter[])ContainerUtil.map((Object[])parameters, parameter -> this.createClosureParameter((GrParameter)parameter), (Object[])new GrClosureParameter[parameters.length]);
    }

    @NotNull
    protected GrClosureParameter createClosureParameter(@NotNull GrParameter parameter) {
        return new GrClosureParameterImpl(parameter);
    }

    @Override
    public int getParameterCount() {
        return this.myBlock.getAllParameters().length;
    }

    @Override
    public boolean isVarargs() {
        GrParameter last = (GrParameter)ArrayUtil.getLastElement((Object[])this.myBlock.getAllParameters());
        return last != null && last.getType() instanceof PsiArrayType;
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return this.myBlock.getReturnType();
    }

    @Override
    public boolean isCurried() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myBlock.isValid();
    }

    @Override
    @Nullable
    public GrSignature curry(@NotNull PsiType[] args, int position, @NotNull PsiElement context) {
        return GrClosureSignatureUtil.curryImpl(this, args, position, context);
    }

    @Override
    public void accept(@NotNull GrSignatureVisitor visitor2) {
        visitor2.visitClosureSignature(this);
    }
}

