/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;

class GrClosureParameterImpl
implements GrClosureParameter {
    private final PsiParameter myParameter;
    private final PsiSubstitutor mySubstitutor;
    private final boolean myEraseType;

    public GrClosureParameterImpl(@NotNull PsiParameter parameter) {
        this(parameter, PsiSubstitutor.EMPTY, false);
    }

    public GrClosureParameterImpl(@NotNull PsiParameter parameter, @NotNull PsiSubstitutor substitutor, boolean eraseType) {
        this.myParameter = parameter;
        this.mySubstitutor = substitutor;
        this.myEraseType = eraseType;
    }

    @Override
    @Nullable
    public PsiType getType() {
        PsiType type = this.mySubstitutor.substitute(this.myParameter.getType());
        return this.myEraseType ? TypeConversionUtil.erasure((PsiType)type) : type;
    }

    @Override
    public boolean isOptional() {
        return this.myParameter instanceof GrParameter && ((GrParameter)this.myParameter).isOptional();
    }

    @Override
    @Nullable
    public GrExpression getDefaultInitializer() {
        return this.myParameter instanceof GrParameter ? ((GrParameter)this.myParameter).getInitializerGroovy() : null;
    }

    @Override
    public boolean isValid() {
        return this.myParameter.isValid();
    }

    @Override
    @Nullable
    public String getName() {
        return this.myParameter.getName();
    }
}

