/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrForStatementImpl
extends GroovyPsiElementImpl
implements GrForStatement {
    public GrForStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitForStatement(this);
    }

    public String toString() {
        return "For statement";
    }

    @Override
    @Nullable
    public GrForClause getClause() {
        return (GrForClause)this.findChildByClass(GrForClause.class);
    }

    @Override
    @Nullable
    public GrStatement getBody() {
        return (GrStatement)this.findChildByClass(GrStatement.class);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (!ResolveUtil.shouldProcessProperties((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        GrForClause forClause = this.getClause();
        GrVariable varScope = (GrVariable)PsiTreeUtil.getParentOfType((PsiElement)place, GrVariable.class);
        if (forClause == null) {
            return true;
        }
        if (lastParent == null || lastParent instanceof GrForInClause) {
            return true;
        }
        GrVariable var = forClause.getDeclaredVariable();
        if (var == null || var.equals(varScope)) {
            return true;
        }
        return ResolveUtil.processElement(processor, var, state);
    }

    @Override
    public <T extends GrCondition> T replaceBody(T newBody) throws IncorrectOperationException {
        return PsiImplUtil.replaceBody(newBody, this.getBody(), this.getNode(), this.getProject());
    }

    @Override
    public PsiElement getRParenth() {
        return this.findChildByType(GroovyTokenTypes.mRPAREN);
    }

    @Override
    public PsiElement getLParenth() {
        return this.findChildByType(GroovyTokenTypes.mLPAREN);
    }
}

