/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.profiling.ResolveProfiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public abstract class GrBlockImpl
extends LazyParseablePsiElement
implements GrCodeBlock,
GrControlFlowOwner {
    private static final Key<CachedValue<Instruction[]>> CONTROL_FLOW = Key.create((String)"Control flow");

    protected GrBlockImpl(@NotNull IElementType type, CharSequence buffer) {
        super(type, buffer);
    }

    public void delete() throws IncorrectOperationException {
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable((PsiElement)this);
            ((ASTDelegatePsiElement)this.getParent()).deleteChildInternal(this.getNode());
        } else {
            this.getParent().deleteChildRange((PsiElement)this, (PsiElement)this);
        }
    }

    @Override
    public void removeElements(PsiElement[] elements) throws IncorrectOperationException {
        GroovyPsiElementImpl.removeElements(this, elements);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
        GroovyPsiElementImpl.acceptGroovyChildren(this, visitor2);
    }

    public <T extends GrStatement> T replaceWithStatement(T statement) {
        return GroovyPsiElementImpl.replaceWithStatement(this, statement);
    }

    public void clearCaches() {
        super.clearCaches();
        this.putUserData(CONTROL_FLOW, null);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement element = child.getPsi();
        if (element instanceof GrStatement) {
            PsiImplUtil.deleteStatementTail(this, element);
        }
        super.deleteChildInternal(child);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        if (last instanceof GrStatement) {
            PsiImplUtil.deleteStatementTail(this, last);
        }
        super.deleteChildRange(first, last);
    }

    @Override
    public Instruction[] getControlFlow() {
        assert (this.isValid());
        CachedValue controlFlow = (CachedValue)this.getUserData(CONTROL_FLOW);
        if (controlFlow == null) {
            controlFlow = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                try {
                    ResolveProfiler.start();
                    Instruction[] flow = new ControlFlowBuilder(this.getProject()).buildControlFlow(this);
                    CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)flow, (Object[])new Object[]{this.getContainingFile(), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                    return result;
                }
                finally {
                    long time = ResolveProfiler.finish();
                    ResolveProfiler.write((String)"flow", (PsiElement)this, (long)time);
                }
            }, false);
            controlFlow = (CachedValue)this.putUserDataIfAbsent(CONTROL_FLOW, controlFlow);
        }
        return ControlFlowBuilder.assertValidPsi((Instruction[])controlFlow.getValue());
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    private boolean mayUseNewLinesAsSeparators() {
        for (GrBlockImpl parent = this; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof GrString)) continue;
            GrString grString = (GrString)((Object)parent);
            return !grString.isPlainString();
        }
        return true;
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        return PsiImplUtil.getStatements(this);
    }

    @Override
    @NotNull
    public GrStatement addStatementBefore(@NotNull GrStatement element, @Nullable GrStatement anchor) throws IncorrectOperationException {
        GrStatement actualAnchor;
        if (anchor == null && this.getRBrace() == null) {
            throw new IncorrectOperationException();
        }
        if (anchor != null && !this.equals(anchor.getParent())) {
            throw new IncorrectOperationException();
        }
        LeafElement nls = Factory.createSingleLeafElement((IElementType)GroovyTokenTypes.mNLS, (CharSequence)"\n", (int)0, (int)1, null, (PsiManager)this.getManager());
        GrStatement grStatement = actualAnchor = anchor == null ? this.getRBrace() : anchor;
        if (this.mayUseNewLinesAsSeparators()) {
            PsiElement prev = actualAnchor.getPrevSibling();
            if (prev instanceof GrParameterList && prev.getTextLength() == 0 && prev.getPrevSibling() != null) {
                prev = prev.getPrevSibling();
            }
            if (!PsiUtil.isLineFeed(prev)) {
                this.addBefore(nls.getPsi(), actualAnchor);
            }
        }
        element = (GrStatement)this.addBefore(element, actualAnchor);
        if (this.mayUseNewLinesAsSeparators()) {
            this.addBefore(nls.getPsi(), actualAnchor);
        } else {
            this.addBefore(Factory.createSingleLeafElement((IElementType)GroovyTokenTypes.mNLS, (CharSequence)"\n", (int)0, (int)1, null, (PsiManager)this.getManager()).getPsi(), actualAnchor);
        }
        return element;
    }

    @Override
    public PsiElement getLBrace() {
        return this.findPsiChildByType(GroovyTokenTypes.mLCURLY);
    }

    @Override
    @Nullable
    public PsiElement getRBrace() {
        return this.findPsiChildByType(GroovyTokenTypes.mRCURLY);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return ResolveUtil.processChildren(this, processor, state, lastParent, place);
    }
}

