/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import gnu.trove.THashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class ClassUtil {
    private static final LightCacheKey<Map<String, PsiClass>> PARENT_CACHE_KEY = LightCacheKey.create();

    public static Map<String, PsiClass> getSuperClassesWithCache(@NotNull PsiClass aClass) {
        Map<String, PsiClass> superClassNames = PARENT_CACHE_KEY.getCachedValue((PsiElement)aClass);
        if (superClassNames == null) {
            THashSet superClasses = new THashSet();
            superClasses.add(aClass);
            InheritanceUtil.getSuperClasses((PsiClass)aClass, (Set)superClasses, (boolean)true);
            superClassNames = new LinkedHashMap<String, PsiClass>();
            for (PsiClass superClass : superClasses) {
                superClassNames.put(superClass.getQualifiedName(), superClass);
            }
            superClassNames = PARENT_CACHE_KEY.putCachedValue((PsiElement)aClass, superClassNames);
        }
        return superClassNames;
    }

    public static String getClassKey(String fqName) {
        return "Class: " + fqName;
    }
}

