/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrBuiltInTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnonymousClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path.GrCallExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrInnerClassConstructorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrNewExpressionImpl
extends GrCallExpressionImpl
implements GrNewExpression {
    private static final Function<GrNewExpressionImpl, PsiType> MY_TYPE_CALCULATOR = newExpression -> {
        GrAnonymousClassDefinition anonymous = newExpression.getAnonymousClassDefinition();
        if (anonymous != null) {
            return new GrAnonymousClassType(LanguageLevel.JDK_1_5, anonymous.getResolveScope(), JavaPsiFacade.getInstance((Project)newExpression.getProject()), anonymous);
        }
        GrClassReferenceType type = null;
        GrCodeReferenceElement refElement = newExpression.getReferenceElement();
        if (refElement != null) {
            type = new GrClassReferenceType(refElement);
        } else {
            GrBuiltInTypeElement builtin = (GrBuiltInTypeElement)newExpression.findChildByClass(GrBuiltInTypeElement.class);
            if (builtin != null) {
                type = builtin.getType();
            }
        }
        if (type != null) {
            for (int i = 0; i < newExpression.getArrayCount(); ++i) {
                type = type.createArrayType();
            }
            return type;
        }
        return null;
    };
    private static final ResolveCache.PolyVariantResolver<MyFakeReference> RESOLVER = new ResolveCache.PolyVariantResolver<MyFakeReference>(){

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull MyFakeReference reference, boolean incompleteCode) {
            return reference.getElement().resolveImpl(incompleteCode);
        }
    };
    private final MyFakeReference myFakeReference = new MyFakeReference();

    public GrNewExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "NEW expression";
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitNewExpression(this);
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, MY_TYPE_CALCULATOR);
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) throws IncorrectOperationException {
        GrArgumentList list = this.getArgumentList();
        if (list == null) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            GrArgumentList newList = factory.createExpressionArgumentList(new GrExpression[0]);
            PsiElement last = this.getLastChild();
            assert (last != null);
            while (last.getPrevSibling() instanceof PsiWhiteSpace || last.getPrevSibling() instanceof PsiErrorElement) {
                last = last.getPrevSibling();
                assert (last != null);
            }
            ASTNode astNode = last.getNode();
            assert (astNode != null);
            this.getNode().addChild(newList.getNode(), astNode);
        }
        return super.addNamedArgument(namedArgument);
    }

    @Override
    @Nullable
    public GrArgumentList getArgumentList() {
        GrAnonymousClassDefinition anonymous = this.getAnonymousClassDefinition();
        if (anonymous != null) {
            return anonymous.getArgumentListGroovy();
        }
        return super.getArgumentList();
    }

    @Override
    public GrCodeReferenceElement getReferenceElement() {
        GrAnonymousClassDefinition anonymous = this.getAnonymousClassDefinition();
        if (anonymous != null) {
            return anonymous.getBaseClassReferenceGroovy();
        }
        return (GrCodeReferenceElement)this.findChildByClass(GrCodeReferenceElement.class);
    }

    @Override
    public GroovyResolveResult[] multiResolveClass() {
        GrCodeReferenceElement referenceElement = this.getReferenceElement();
        if (referenceElement != null) {
            return referenceElement.multiResolve(false);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    @Override
    public int getArrayCount() {
        GrArrayDeclaration arrayDeclaration = this.getArrayDeclaration();
        if (arrayDeclaration == null) {
            return 0;
        }
        return arrayDeclaration.getArrayCount();
    }

    @Override
    public GrAnonymousClassDefinition getAnonymousClassDefinition() {
        return (GrAnonymousClassDefinition)this.findChildByClass(GrAnonymousClassDefinition.class);
    }

    @Override
    @Nullable
    public GrArrayDeclaration getArrayDeclaration() {
        return (GrArrayDeclaration)this.findChildByClass(GrArrayDeclaration.class);
    }

    @Override
    @Nullable
    public GrTypeArgumentList getConstructorTypeArguments() {
        return (GrTypeArgumentList)this.findChildByClass(GrTypeArgumentList.class);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        GrCodeReferenceElement referenceElement = this.getReferenceElement();
        if (referenceElement == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        for (GroovyResolveResult classResult : referenceElement.multiResolve(false)) {
            PsiElement element = classResult.getElement();
            if (!(element instanceof PsiClass)) continue;
            ContainerUtil.addAll(result, (Object[])ResolveUtil.getAllClassConstructors((PsiClass)element, classResult.getSubstitutor(), null, this));
        }
        return result.toArray(new GroovyResolveResult[result.size()]);
    }

    @Override
    public GrTypeElement getTypeElement() {
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        if (this.getArrayCount() > 0 || this.getReferenceElement() == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return TypeInferenceHelper.getCurrentContext().multiResolve(this.myFakeReference, incompleteCode, RESOLVER);
    }

    private GroovyResolveResult[] resolveImpl(boolean incompleteCode) {
        PsiType[] types;
        GrCodeReferenceElement ref = this.getReferenceElement();
        if (ref == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult classCandidate = GrNewExpressionImpl.inferClassCandidate(ref);
        if (classCandidate == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        assert (classCandidate.getElement() instanceof PsiClass);
        if (incompleteCode) {
            return PsiUtil.getConstructorCandidates(ref, classCandidate, null);
        }
        GrArgumentList argumentList = this.getArgumentList();
        if (argumentList == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (argumentList.getNamedArguments().length > 0 && argumentList.getExpressionArguments().length == 0) {
            GroovyResolveResult[] constructorResults;
            GrMapType mapType = GrMapType.createFromNamedArgs(argumentList, this.getNamedArguments());
            for (GroovyResolveResult result : constructorResults = PsiUtil.getConstructorCandidates(ref, classCandidate, new PsiType[]{mapType})) {
                PsiMethod constructor;
                PsiParameter[] parameters;
                PsiElement resolved = result.getElement();
                if (!(resolved instanceof PsiMethod) || (parameters = (constructor = (PsiMethod)resolved).getParameterList().getParameters()).length != 1 || !InheritanceUtil.isInheritor((PsiType)parameters[0].getType(), (String)"java.util.Map")) continue;
                return constructorResults;
            }
            GroovyResolveResult[] emptyConstructors = PsiUtil.getConstructorCandidates(ref, classCandidate, PsiType.EMPTY_ARRAY);
            if (emptyConstructors.length > 0) {
                return emptyConstructors;
            }
        }
        if ((types = PsiUtil.getArgumentTypes(ref, true)) != null) {
            types = GrInnerClassConstructorUtil.addEnclosingArgIfNeeded(types, this, (PsiClass)classCandidate.getElement());
        }
        return PsiUtil.getConstructorCandidates(ref, classCandidate, types);
    }

    @Nullable
    private static GroovyResolveResult inferClassCandidate(@NotNull GrCodeReferenceElement ref) {
        GroovyResolveResult[] classResults;
        for (GroovyResolveResult result : classResults = ref.multiResolve(false)) {
            if (!(result.getElement() instanceof PsiClass)) continue;
            return result;
        }
        return null;
    }

    private class MyFakeReference
    implements PsiPolyVariantReference {
        private MyFakeReference() {
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            return GrNewExpressionImpl.this.multiResolve(incompleteCode);
        }

        public GrNewExpressionImpl getElement() {
            return GrNewExpressionImpl.this;
        }

        public TextRange getRangeInElement() {
            return TextRange.EMPTY_RANGE;
        }

        @Nullable
        public PsiElement resolve() {
            return GrNewExpressionImpl.this.resolveMethod();
        }

        @NotNull
        public String getCanonicalText() {
            return "new expression";
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            throw new UnsupportedOperationException("unsupported!");
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            throw new UnsupportedOperationException("unsupported!");
        }

        public boolean isReferenceTo(PsiElement element) {
            return GrNewExpressionImpl.this.getManager().areElementsEquivalent(element, this.resolve());
        }

        @NotNull
        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }
    }
}

