/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrExpressionTypeCalculator;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

public class GrClosureDelegateTypeCalculator
extends GrExpressionTypeCalculator {
    @Override
    @Nullable
    public PsiType calculateType(@NotNull GrExpression expression, @Nullable PsiElement resolved) {
        if (expression instanceof GrReferenceExpression && resolved instanceof PsiMethod) {
            return this.calculateType(expression, (PsiMethod)resolved);
        }
        return null;
    }

    @Nullable
    protected PsiType calculateType(@NotNull GrExpression expression, @NotNull PsiMethod method) {
        if (!"getDelegate".equals(method.getName()) || method.getParameterList().getParametersCount() != 0) {
            return null;
        }
        GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)expression, GrClosableBlock.class);
        if (closure == null) {
            return null;
        }
        PsiClass closureClass = JavaPsiFacade.getInstance((Project)expression.getProject()).findClass("groovy.lang.Closure", expression.getResolveScope());
        if (closureClass == null || !closureClass.equals(method.getContainingClass())) {
            return null;
        }
        DelegatesToInfo info = GrDelegatesToUtilKt.getDelegatesToInfo(closure);
        if (info == null) {
            return null;
        }
        return info.getTypeToDelegate();
    }
}

