/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBuiltinTypeClassExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrIndexPropertyImpl
extends GrExpressionImpl
implements GrIndexProperty {
    private static final Function<GrIndexPropertyImpl, PsiType> TYPE_CALCULATOR = index -> index.inferType(null);
    private static final ResolveCache.PolyVariantResolver<MyReference> RESOLVER = new ResolveCache.PolyVariantResolver<MyReference>(){

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull MyReference reference, boolean incompleteCode) {
            GrIndexPropertyImpl index = reference.getElement();
            return index.resolveImpl(incompleteCode, null, null);
        }
    };
    private final MyReference myReference = new MyReference();

    private PsiType inferType(@Nullable Boolean isSetter) {
        String name;
        GrArgumentList argList;
        PsiType[] argTypes;
        GrExpression selected = this.getInvokedExpression();
        PsiType thisType = selected.getType();
        if (thisType == null) {
            thisType = TypesUtil.getJavaLangObject(this);
        }
        if ((argTypes = PsiUtil.getArgumentTypes(argList = this.getArgumentList())) == null) {
            return null;
        }
        PsiManagerEx manager = this.getManager();
        GlobalSearchScope resolveScope = this.getResolveScope();
        if (argTypes.length == 0) {
            String qname;
            PsiElement resolved;
            PsiPrimitiveType arrType = null;
            if (selected instanceof GrBuiltinTypeClassExpression) {
                arrType = ((GrBuiltinTypeClassExpression)selected).getPrimitiveType();
            }
            if (selected instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)selected).resolve()) instanceof PsiClass && (qname = ((PsiClass)resolved).getQualifiedName()) != null) {
                arrType = TypesUtil.createTypeByFQClassName(qname, this);
            }
            if (arrType != null) {
                PsiArrayType param = arrType.createArrayType();
                return TypesUtil.createJavaLangClassType((PsiType)param, this.getProject(), resolveScope);
            }
        }
        if (PsiImplUtil.isSimpleArrayAccess(thisType, argTypes, this, isSetter != null ? isSetter : PsiUtil.isLValue(this))) {
            return TypesUtil.boxPrimitiveType(((PsiArrayType)thisType).getComponentType(), (PsiManager)manager, resolveScope);
        }
        GroovyResolveResult[] candidates = isSetter != null ? (isSetter != false ? this.multiResolveSetter(false) : this.multiResolveGetter(false)) : this.multiResolve(false);
        Object[] args = PsiUtil.getArgumentTypes(argList.getNamedArguments(), argList.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, true, null);
        GroovyResolveResult candidate = PsiImplUtil.extractUniqueResult(candidates);
        PsiElement element = candidate.getElement();
        if (element instanceof PsiNamedElement && "putAt".equals(name = ((PsiNamedElement)element).getName()) && args != null) {
            args = (PsiType[])ArrayUtil.append((Object[])args, (Object)TypeInferenceHelper.getInitializerTypeFor(this), PsiType.class);
        }
        PsiType overloadedOperatorType = ResolveUtil.extractReturnTypeFromCandidate(candidate, this, (PsiType[])args);
        PsiType componentType = GrIndexPropertyImpl.extractMapValueType(thisType, (PsiType[])args, (PsiManager)manager, resolveScope);
        if (!(overloadedOperatorType == null || componentType != null && TypesUtil.isAssignableByMethodCallConversion(overloadedOperatorType, componentType, selected))) {
            return TypesUtil.boxPrimitiveType(overloadedOperatorType, (PsiManager)manager, resolveScope);
        }
        return componentType;
    }

    @Nullable
    private static PsiType extractMapValueType(PsiType thisType, PsiType[] argTypes, PsiManager manager, GlobalSearchScope resolveScope) {
        if (argTypes.length != 1 || !InheritanceUtil.isInheritor((PsiType)thisType, (String)"java.util.Map")) {
            return null;
        }
        PsiType substituted = com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)thisType, (String)"java.util.Map", (int)1, (boolean)true);
        return TypesUtil.boxPrimitiveType(substituted, manager, resolveScope);
    }

    private GroovyResolveResult[] resolveImpl(boolean incompleteCode, @Nullable GrExpression upToArgument, @Nullable Boolean isSetter) {
        String name;
        GrArgumentList argList;
        Object[] argTypes;
        GrExpression invoked;
        PsiType thisType;
        if (isSetter == null) {
            isSetter = PsiUtil.isLValue(this);
        }
        if ((thisType = (invoked = this.getInvokedExpression()).getType()) == null) {
            thisType = TypesUtil.getJavaLangObject(this);
        }
        if ((argTypes = PsiUtil.getArgumentTypes((argList = this.getArgumentList()).getNamedArguments(), argList.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, true, upToArgument)) == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GlobalSearchScope resolveScope = this.getResolveScope();
        if (argTypes.length == 0) {
            String qname;
            PsiElement resolved;
            PsiPrimitiveType arrType = null;
            if (invoked instanceof GrBuiltinTypeClassExpression) {
                arrType = ((GrBuiltinTypeClassExpression)invoked).getPrimitiveType();
            }
            if (invoked instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)invoked).resolve()) instanceof PsiClass && (qname = ((PsiClass)resolved).getQualifiedName()) != null) {
                arrType = TypesUtil.createTypeByFQClassName(qname, this);
            }
            if (arrType != null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
        }
        String string = name = isSetter != false ? "putAt" : "getAt";
        if (isSetter.booleanValue() && !incompleteCode) {
            argTypes = (PsiType[])ArrayUtil.append((Object[])argTypes, (Object)TypeInferenceHelper.getInitializerTypeFor(this), PsiType.class);
        }
        if (PsiImplUtil.isSimpleArrayAccess(thisType, (PsiType[])argTypes, this, isSetter)) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        Object[] candidates = ResolveUtil.getMethodCandidates(thisType, name, (PsiElement)invoked, true, incompleteCode, (PsiType[])argTypes);
        if (candidates.length == 2) {
            for (int i = 0; i < candidates.length; ++i) {
                PsiMethod staticMethod;
                PsiParameter param;
                GroovyResolveResult candidate = candidates[i];
                PsiElement element = candidate.getElement();
                if (!(element instanceof GrGdkMethod) || !(param = (staticMethod = ((GrGdkMethod)element).getStaticMethod()).getParameterList().getParameters()[0]).getType().equalsToText("java.lang.Object")) continue;
                return new GroovyResolveResult[]{candidates[1 - i]};
            }
        }
        if (candidates.length != 1) {
            GrImmediateTupleType tupleType = new GrImmediateTupleType((PsiType[])argTypes, JavaPsiFacade.getInstance((Project)this.getProject()), resolveScope);
            Object[] tupleCandidates = ResolveUtil.getMethodCandidates(thisType, name, (PsiElement)invoked, new PsiType[]{tupleType});
            candidates = incompleteCode ? (GroovyResolveResult[])ArrayUtil.mergeArrays((Object[])candidates, (Object[])tupleCandidates, GroovyResolveResult[]::new) : tupleCandidates;
        }
        return candidates;
    }

    public GrIndexPropertyImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitIndexProperty(this);
    }

    public String toString() {
        return "Property by index";
    }

    @Override
    @NotNull
    public GrExpression getInvokedExpression() {
        return (GrExpression)this.findNotNullChildByClass(GrExpression.class);
    }

    @Override
    @NotNull
    public GrArgumentList getArgumentList() {
        return (GrArgumentList)this.findNotNullChildByClass(GrArgumentList.class);
    }

    @Override
    @Nullable
    public PsiType getGetterType() {
        return this.inferType(false);
    }

    @Override
    @Nullable
    public PsiType getSetterType() {
        return this.inferType(true);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolveGetter(boolean incomplete) {
        return this.resolveImpl(incomplete, null, false);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolveSetter(boolean incomplete) {
        return this.resolveImpl(incomplete, null, true);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        return TypeInferenceHelper.getCurrentContext().multiResolve(this.myReference, incompleteCode, RESOLVER);
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    @Override
    public PsiType getNominalType() {
        if (this.getParent() instanceof GrThrowStatement) {
            return super.getNominalType();
        }
        GroovyResolveResult[] candidates = this.multiResolve(true);
        if (candidates.length == 1) {
            return this.extractLastParameterType(candidates[0]);
        }
        return null;
    }

    @Nullable
    private PsiType extractLastParameterType(GroovyResolveResult candidate) {
        PsiParameter[] parameters;
        PsiElement element = candidate.getElement();
        if (element instanceof PsiMethod && (parameters = ((PsiMethod)element).getParameterList().getParameters()).length > 1) {
            PsiParameter last = parameters[parameters.length - 1];
            return TypesUtil.substituteAndNormalizeType(last.getType(), candidate.getSubstitutor(), candidate.getSpreadState(), this);
        }
        return null;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        GrArgumentList list = this.getArgumentList();
        return list.getNamedArguments();
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        GrArgumentList list = this.getArgumentList();
        return list.getExpressionArguments();
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) throws IncorrectOperationException {
        GrArgumentList list = this.getArgumentList();
        return list.addNamedArgument(namedArgument);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        if (upToArgument == null) {
            return this.multiResolve(true);
        }
        return this.resolveImpl(true, upToArgument, null);
    }

    @Override
    @NotNull
    public GrClosableBlock[] getClosureArguments() {
        return GrClosableBlock.EMPTY_ARRAY;
    }

    public PsiReference getReference() {
        return this.myReference;
    }

    private class MyReference
    implements PsiPolyVariantReference {
        private MyReference() {
        }

        public GrIndexPropertyImpl getElement() {
            return GrIndexPropertyImpl.this;
        }

        public TextRange getRangeInElement() {
            int offset = GrIndexPropertyImpl.this.getArgumentList().getStartOffsetInParent();
            return new TextRange(offset, offset + 1);
        }

        public PsiElement resolve() {
            return GrIndexPropertyImpl.this.resolveMethod();
        }

        @NotNull
        public String getCanonicalText() {
            return "Array-style access";
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return GrIndexPropertyImpl.this;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            return GrIndexPropertyImpl.this;
        }

        public boolean isReferenceTo(PsiElement element) {
            return GrIndexPropertyImpl.this.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            return GrIndexPropertyImpl.this.multiResolve(incompleteCode);
        }
    }
}

