/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;

public class GrAnonymousClassDefinitionImpl
extends GrTypeDefinitionImpl
implements GrAnonymousClassDefinition {
    private SoftReference<PsiClassType> myCachedBaseType;

    public GrAnonymousClassDefinitionImpl(@NotNull ASTNode node) {
        super(node);
    }

    public GrAnonymousClassDefinitionImpl(GrTypeDefinitionStub stub) {
        this(stub, GroovyElementTypes.ANONYMOUS_CLASS_DEFINITION);
    }

    public GrAnonymousClassDefinitionImpl(GrTypeDefinitionStub stub, GrStubElementType nodeType) {
        super(stub, (IStubElementType)nodeType);
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getBaseClassReferenceGroovy() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            GrCodeReferenceElement reference = stub.getBaseClassReference();
            assert (reference != null);
            return reference;
        }
        return (GrCodeReferenceElement)this.findNotNullChildByClass(GrCodeReferenceElement.class);
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        return "final".equals(name);
    }

    @Override
    @Nullable
    public GrArgumentList getArgumentListGroovy() {
        return (GrArgumentList)this.findChildByClass(GrArgumentList.class);
    }

    public boolean isInQualifiedNew() {
        return false;
    }

    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        return JavaPsiFacade.getElementFactory((Project)this.getProject()).createReferenceElementByType(this.getBaseClassType());
    }

    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassType type = (PsiClassType)SoftReference.dereference(this.myCachedBaseType);
        if (type != null && type.isValid()) {
            return type;
        }
        type = new GrClassReferenceType(this.getBaseClassReferenceGroovy());
        this.myCachedBaseType = new SoftReference((Object)type);
        return type;
    }

    @Nullable
    public PsiExpressionList getArgumentList() {
        return null;
    }

    @Nullable
    private PsiClass getBaseClass() {
        return this.getBaseClassType().resolve();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        return this.getBaseClassReferenceGroovy().getReferenceNameElement();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (lastParent instanceof GrArgumentList) {
            return true;
        }
        GrCodeReferenceElement refElement = this.getBaseClassReferenceGroovy();
        if (refElement == place || refElement == lastParent) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public PsiClass getSuperClass() {
        PsiClass psiClass = this.getBaseClass();
        if (psiClass != null && !psiClass.isInterface()) {
            return psiClass;
        }
        return JavaPsiFacade.getInstance((Project)this.getProject()).findClass("java.lang.Object", this.getResolveScope());
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes(boolean includeSynthetic) {
        return PsiClassType.EMPTY_ARRAY;
    }

    @Override
    public GrExtendsClause getExtendsClause() {
        return null;
    }

    @Override
    public GrImplementsClause getImplementsClause() {
        return null;
    }

    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes(boolean includeSynthetic) {
        return PsiClassType.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes(boolean includeSynthetic) {
        PsiClassType baseClassType = this.getBaseClassType();
        PsiClass baseClass = baseClassType.resolve();
        if (baseClass == null || !baseClass.isInterface()) {
            return new PsiClassType[]{baseClassType};
        }
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
        return new PsiClassType[]{objectType, baseClassType};
    }

    public String toString() {
        return "Anonymous class";
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    protected Object clone() {
        Object o = super.clone();
        ((GrAnonymousClassDefinitionImpl)o).myCachedBaseType = null;
        return o;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitAnonymousClassDefinition(this);
    }
}

