/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameterListBuilder;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GrAccessorMethodImpl
extends LightMethodBuilder
implements GrAccessorMethod {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrAccessorMethodImpl");
    @NotNull
    private final GrField myProperty;
    private final boolean myIsSetter;

    public GrAccessorMethodImpl(@NotNull GrField property, boolean isSetter, String name) {
        super(property.getManager(), (Language)GroovyLanguage.INSTANCE, name, (PsiParameterList)new LightParameterListBuilder(property.getManager(), (Language)GroovyLanguage.INSTANCE), (PsiModifierList)new LightModifierList(property.getManager()){

            public String getText() {
                String[] modifiers = this.getModifiers();
                if (modifiers.length == 0) {
                    return "";
                }
                if (modifiers.length == 1) {
                    return modifiers[0];
                }
                return StringUtil.join((String[])modifiers, (String)" ");
            }
        });
        this.myProperty = property;
        this.myIsSetter = isSetter;
        if (this.myIsSetter) {
            PsiType type = this.myProperty.getDeclaredType();
            if (type == null) {
                type = TypesUtil.getJavaLangObject(this.myProperty);
            }
            this.addParameter(this.myProperty.getName(), type);
        }
        this.setMethodReturnType((PsiType)(this.myIsSetter ? PsiType.VOID : this.myProperty.getType()));
        this.addModifier("public");
        if (this.myProperty.hasModifierProperty("static")) {
            this.addModifier("static");
        } else if (this.myProperty.hasModifierProperty("final")) {
            this.addModifier("final");
        }
        if (this.myProperty.hasModifierProperty("abstract") && GrTraitUtil.isTrait(this.myProperty.getContainingClass())) {
            this.addModifier("abstract");
        }
        this.setNavigationElement(property);
        this.setBaseIcon(JetgroovyIcons.Groovy.Property);
        this.setContainingClass(this.myProperty.getContainingClass());
        this.setMethodKind("AccessorMethod");
        this.setOriginInfo("synthetic accessor for '" + this.myProperty.getName() + "'");
    }

    @Override
    @Nullable
    public PsiType getInferredReturnType() {
        if (this.myIsSetter) {
            return PsiType.VOID;
        }
        return this.myProperty.getTypeGroovy();
    }

    @Override
    public boolean isSetter() {
        return this.myIsSetter;
    }

    public PsiElement copy() {
        String modifiers = this.getModifierList().getText();
        String params = this.myIsSetter ? "(" + this.myProperty.getName() + ")" : "()";
        return GroovyPsiElementFactory.getInstance(this.getProject()).createMethodFromText(modifiers + " " + this.getName() + params + "{}");
    }

    @Override
    @NotNull
    public GrField getProperty() {
        return this.myProperty;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another == this) {
            return true;
        }
        if (!(another instanceof GrAccessorMethod)) {
            return false;
        }
        if (!((GrAccessorMethod)another).getName().equals(this.getName())) {
            return false;
        }
        return this.getManager().areElementsEquivalent((PsiElement)this.myProperty, (PsiElement)((GrAccessorMethod)another).getProperty());
    }

    @NotNull
    public PsiElement getPrototype() {
        return this.getProperty();
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (GrTraitUtil.isTrait(this.getContainingClass())) {
            if ("abstract".equals(name)) {
                return true;
            }
            if ("final".equals(name)) {
                return false;
            }
        }
        return super.hasModifierProperty(name);
    }
}

