/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;

public class GrLightModifierList
extends LightElement
implements GrModifierList {
    private int myModifiers;
    private final List<GrAnnotation> myAnnotations = new ArrayList<GrAnnotation>();
    private final PsiElement myParent;

    public GrLightModifierList(@NotNull PsiElement parent) {
        super(parent.getManager(), parent.getLanguage());
        this.myParent = parent;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public PsiFile getContainingFile() {
        return this.getParent().getContainingFile();
    }

    public void addModifier(String modifier) {
        int code = GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)modifier);
        assert (code != 0);
        this.myModifiers |= code;
    }

    public void addModifier(int modifier) {
        this.myModifiers |= modifier;
    }

    public void removeModifier(int modifier) {
        this.myModifiers &= ~modifier;
    }

    public void setModifiers(int modifiers) {
        this.myModifiers = modifiers;
    }

    public void setModifiers(String ... modifiers) {
        this.myModifiers = 0;
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
    }

    @Override
    public int getModifierFlags() {
        return this.myModifiers;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        return GrModifierListUtil.hasModifierProperty(this, name);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        return GrModifierListUtil.hasExplicitModifier(this, name);
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public GrAnnotation[] getRawAnnotations() {
        return this.getAnnotations();
    }

    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public GrAnnotation[] getAnnotations() {
        return this.myAnnotations.toArray(new GrAnnotation[this.myAnnotations.size()]);
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        GrLightAnnotation annotation = new GrLightAnnotation(this.getManager(), this.getLanguage(), qualifiedName, (PsiAnnotationOwner)this);
        this.myAnnotations.add(annotation);
        return annotation;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList((PsiModifierList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "GrModifierList";
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (GrAnnotation annotation : this.myAnnotations) {
            buffer.append(annotation.getText());
            buffer.append(' ');
        }
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @Override
    @NotNull
    public PsiElement[] getModifiers() {
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiElement getModifier(@GrModifier.GrModifierConstant @NotNull @NonNls String name) {
        return null;
    }

    @Override
    public boolean hasExplicitVisibilityModifiers() {
        return GrModifierListUtil.hasExplicitVisibilityModifiers(this);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitModifierList(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
    }

    public void copyModifiers(@NotNull PsiModifierListOwner modifierOwner) {
        int mod = 0;
        PsiModifierList modifierList = modifierOwner.getModifierList();
        if (modifierList instanceof GrModifierList) {
            mod = ((GrModifierList)modifierList).getModifierFlags();
        } else if (modifierList != null) {
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!modifierList.hasExplicitModifier(modifier)) continue;
                mod |= GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)modifier);
            }
        }
        this.setModifiers(mod);
    }
}

