/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GrTraitField
extends GrLightField
implements PsiMirrorElement {
    private static final Logger LOG = Logger.getInstance(GrTraitField.class);
    private final PsiField myField;

    public GrTraitField(@NotNull PsiField field, GrTypeDefinition clazz, PsiSubstitutor substitutor) {
        super(clazz, GrTraitField.getNewNameForField(field), substitutor.substitute(field.getType()), (PsiElement)field);
        GrModifierList modifierList = this.getModifierList();
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!field.hasModifierProperty(modifier)) continue;
            ((GrLightModifierList)modifierList).addModifier(modifier);
        }
        this.myField = field;
    }

    @NotNull
    private static String getNewNameForField(@NotNull PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        LOG.assertTrue(containingClass != null);
        return GrTraitUtil.getTraitFieldPrefix(containingClass) + field.getName();
    }

    @NotNull
    public PsiField getPrototype() {
        return this.myField;
    }
}

