/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GrStubFileElementType
extends IStubFileElementType<GrFileStub> {
    public static final int STUB_VERSION = 35;

    public GrStubFileElementType(Language language) {
        super(language);
    }

    public StubBuilder getBuilder() {
        return new DefaultStubBuilder(){

            @NotNull
            protected StubElement createStubForFile(@NotNull PsiFile file) {
                if (file instanceof GroovyFile) {
                    return new GrFileStub((GroovyFile)file);
                }
                return super.createStubForFile(file);
            }

            public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
                IElementType childType = node.getElementType();
                IElementType parentType = parent.getElementType();
                if (childType == GroovyElementTypes.PARAMETER && parentType != GroovyElementTypes.PARAMETERS_LIST) {
                    return true;
                }
                if (childType == GroovyElementTypes.PARAMETERS_LIST && !(parent.getPsi() instanceof GrMethod)) {
                    return true;
                }
                if (childType == GroovyElementTypes.MODIFIERS) {
                    if (parentType == GroovyElementTypes.CLASS_INITIALIZER) {
                        return true;
                    }
                    if (parentType == GroovyElementTypes.VARIABLE_DEFINITION && !GroovyElementTypes.VARIABLE_DEFINITION.shouldCreateStub(parent)) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public int getStubVersion() {
        return super.getStubVersion() + 35;
    }

    @NotNull
    public String getExternalId() {
        return "groovy.FILE";
    }

    public void serialize(@NotNull GrFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName().toString());
        dataStream.writeBoolean(stub.isScript());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
    }

    @NotNull
    public GrFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        return new GrFileStub(name, isScript, GrStubUtils.readStringArray(dataStream));
    }

    public void indexStub(@NotNull GrFileStub stub, @NotNull IndexSink sink) {
        String name = stub.getName().toString();
        if (stub.isScript() && name != null) {
            sink.occurrence(GrScriptClassNameIndex.KEY, (Object)name);
            String pName = GrStubUtils.getPackageName(stub);
            String fqn = StringUtil.isEmpty((String)pName) ? name : pName + "." + name;
            sink.occurrence(GrFullScriptNameIndex.KEY, (Object)fqn.hashCode());
        }
        for (String anno : stub.getAnnotations()) {
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)anno);
        }
    }
}

