/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrVariableStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;

public final class GrVariableElementType
extends GrStubElementType<GrVariableStub, GrVariable> {
    public GrVariableElementType() {
        super("assigned variable");
    }

    public void serialize(@NotNull GrVariableStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
        GrStubUtils.writeNullableString(dataStream, stub.getTypeText());
    }

    public GrVariable createPsi(@NotNull GrVariableStub stub) {
        return new GrVariableImpl(stub);
    }

    @NotNull
    public GrVariableStub createStub(@NotNull GrVariable psi, StubElement parentStub) {
        return new GrVariableStub(parentStub, this, StringRef.fromNullableString((String)psi.getName()), GrStubUtils.getAnnotationNames((PsiModifierListOwner)psi), GrStubUtils.getTypeText(psi.getTypeElementGroovy()));
    }

    @NotNull
    public GrVariableStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        String[] annNames = GrStubUtils.readStringArray(dataStream);
        String typeText = GrStubUtils.readNullableString(dataStream);
        return new GrVariableStub(parentStub, this, name, annNames, typeText);
    }

    public boolean shouldCreateStub(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return parent != null && parent.getElementType() == GroovyElementTypes.VARIABLE_DEFINITION && GroovyElementTypes.VARIABLE_DEFINITION.shouldCreateStub(parent);
    }
}

