/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.FromStringLightElement;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;

public class FromStringHintProcessor
extends SignatureHintProcessor {
    @Override
    public String getHintName() {
        return "groovy.transform.stc.FromString";
    }

    @Override
    @NotNull
    public List<PsiType[]> inferExpectedSignatures(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull String[] options) {
        PsiElement context = FromStringHintProcessor.createContext(method);
        return ContainerUtil.map((Object[])options, value -> {
            Object[] params = value.split(",");
            return (PsiType[])ContainerUtil.map((Object[])params, param -> {
                try {
                    PsiType original = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeFromText(param, context);
                    return substitutor.substitute(original);
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    return PsiType.NULL;
                }
            }, (Object[])new PsiType[params.length]);
        });
    }

    public static PsiElement createContext(@NotNull PsiMethod method) {
        return new FromStringLightElement(method);
    }
}

