/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.resolve.ImplicitImportsKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

class FromStringLightElement
extends LightElement {
    private final PsiMethod myMethod;
    private final GroovyFile myFile;

    FromStringLightElement(@NotNull PsiMethod method) {
        super(method.getManager(), (Language)GroovyLanguage.INSTANCE);
        this.myMethod = method;
        this.myFile = GroovyPsiElementFactory.getInstance(this.getProject()).createGroovyFile("", false, null);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass aClass;
        PsiQualifiedReference reference;
        if (!ResolveUtil.shouldProcessClasses((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        for (PsiTypeParameter parameter : this.myMethod.getTypeParameters()) {
            if (ResolveUtil.processElement(processor, (PsiNamedElement)parameter, state)) continue;
            return false;
        }
        PsiClass containingClass = this.myMethod.getContainingClass();
        if (containingClass != null) {
            PsiTypeParameter[] parameters;
            for (PsiTypeParameter parameter : parameters = containingClass.getTypeParameters()) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)parameter, state)) continue;
                return false;
            }
        }
        if (!ImplicitImportsKt.processImplicitImports(processor, state, lastParent, place, this.myFile)) {
            return false;
        }
        return !(place instanceof PsiQualifiedReference) || (reference = (PsiQualifiedReference)place).getQualifier() != null || reference.getReferenceName() == null || (aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(reference.getReferenceName(), this.getResolveScope())) == null || ResolveUtil.processElement(processor, (PsiNamedElement)aClass, state);
    }

    public String toString() {
        return "fromStringLightElement";
    }
}

