/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;

public abstract class ParamHintProcessor
extends SignatureHintProcessor {
    private final int myParam;
    private final int myGeneric;
    private final String myHint;

    public ParamHintProcessor(String hint, int param, int generic) {
        this.myHint = hint;
        this.myParam = param;
        this.myGeneric = generic;
    }

    @Override
    public String getHintName() {
        return this.myHint;
    }

    @Override
    @NotNull
    public List<PsiType[]> inferExpectedSignatures(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull String[] options) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (this.myParam < parameters.length) {
            PsiType[] typeParameters;
            PsiParameter parameter = parameters[this.myParam];
            PsiType originalType = parameter.getType();
            PsiType substituted = substitutor.substitute(originalType);
            if (this.myGeneric == -1) {
                return ParamHintProcessor.produceResult(substituted);
            }
            if (substituted instanceof PsiClassType && this.myGeneric < (typeParameters = ((PsiClassType)substituted).getParameters()).length) {
                return ParamHintProcessor.produceResult(typeParameters[this.myGeneric]);
            }
        }
        return ContainerUtilRt.emptyList();
    }

    @NotNull
    protected static ArrayList<PsiType[]> produceResult(@Nullable PsiType type) {
        PsiType notNull = type != null ? type : PsiType.NULL;
        PsiType[] signature = new PsiType[]{notNull};
        ArrayList result = ContainerUtil.newArrayList();
        result.add(signature);
        return result;
    }
}

