/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.transformations.TransformationUtilKt;

public abstract class NonCodeMembersContributor {
    public static final ExtensionPointName<NonCodeMembersContributor> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.membersContributor");
    private static volatile MultiMap<String, NonCodeMembersContributor> ourClassSpecifiedContributors;
    private static NonCodeMembersContributor[] ourAllTypeContributors;

    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        throw new RuntimeException("One of two 'processDynamicElements()' methods must be implemented");
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        this.processDynamicElements(qualifierType, processor, place, state);
    }

    @Nullable
    protected String getParentClassName() {
        return null;
    }

    private static void ensureInit() {
        if (ourClassSpecifiedContributors != null) {
            return;
        }
        MultiMap contributorMap = new MultiMap();
        for (NonCodeMembersContributor contributor : (NonCodeMembersContributor[])EP_NAME.getExtensions()) {
            contributorMap.putValue((Object)contributor.getParentClassName(), (Object)contributor);
        }
        Collection allTypeContributors = contributorMap.remove(null);
        ourAllTypeContributors = allTypeContributors.toArray(new NonCodeMembersContributor[allTypeContributors.size()]);
        ourClassSpecifiedContributors = contributorMap;
    }

    public static boolean runContributors(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        NonCodeMembersContributor.ensureInit();
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
        if (TransformationUtilKt.isUnderTransformation(aClass)) {
            return true;
        }
        List allDelegates = ContainerUtil.map(GroovyResolverProcessor.allProcessors(processor), MyDelegatingScopeProcessor::new);
        if (aClass != null) {
            for (String superClassName : ClassUtil.getSuperClassesWithCache(aClass).keySet()) {
                for (NonCodeMembersContributor enhancer : ourClassSpecifiedContributors.get((Object)superClassName)) {
                    if (NonCodeMembersContributor.invokeContributor(qualifierType, place, state, aClass, allDelegates, enhancer)) continue;
                    return false;
                }
            }
        }
        for (NonCodeMembersContributor contributor : ourAllTypeContributors) {
            if (NonCodeMembersContributor.invokeContributor(qualifierType, place, state, aClass, allDelegates, contributor)) continue;
            return false;
        }
        return GroovyDslFileIndex.processExecutors(qualifierType, place, processor, state);
    }

    private static boolean invokeContributor(@NotNull PsiType qualifierType, @NotNull PsiElement place, @NotNull ResolveState state, PsiClass aClass, List<MyDelegatingScopeProcessor> allDelegates, NonCodeMembersContributor enhancer) {
        ProgressManager.checkCanceled();
        for (MyDelegatingScopeProcessor delegatingProcessor : allDelegates) {
            enhancer.processDynamicElements(qualifierType, aClass, (PsiScopeProcessor)delegatingProcessor, place, state);
            if (delegatingProcessor.wantMore) continue;
            return false;
        }
        return true;
    }

    private static class MyDelegatingScopeProcessor
    extends DelegatingScopeProcessor {
        public boolean wantMore = true;

        public MyDelegatingScopeProcessor(PsiScopeProcessor delegate) {
            super(delegate);
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (!this.wantMore) {
                return false;
            }
            this.wantMore = super.execute(element, state);
            return this.wantMore;
        }
    }
}

