/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.CollectClassMembersUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class ConstructorAnnotationsProcessor
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        boolean canonical;
        GrTypeDefinition typeDefinition = context.getCodeClass();
        if (typeDefinition.getName() == null) {
            return;
        }
        GrModifierList modifierList = typeDefinition.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiAnnotation tupleConstructor = modifierList.findAnnotation("groovy.transform.TupleConstructor");
        boolean immutable = PsiImplUtil.hasImmutableAnnotation(modifierList);
        boolean bl = canonical = modifierList.findAnnotation("groovy.transform.Canonical") != null;
        if (!immutable && !canonical && tupleConstructor == null) {
            return;
        }
        if (tupleConstructor != null && typeDefinition.getCodeConstructors().length > 0 && !PsiUtil.getAnnoAttributeValue(tupleConstructor, "force", false)) {
            return;
        }
        GrLightMethodBuilder fieldsConstructor = ConstructorAnnotationsProcessor.generateFieldConstructor(typeDefinition, tupleConstructor, immutable, canonical);
        GrLightMethodBuilder mapConstructor = ConstructorAnnotationsProcessor.generateMapConstructor(typeDefinition);
        context.addMethod(fieldsConstructor);
        context.addMethod(mapConstructor);
    }

    @NotNull
    private static GrLightMethodBuilder generateMapConstructor(@NotNull GrTypeDefinition typeDefinition) {
        GrLightMethodBuilder mapConstructor = new GrLightMethodBuilder(typeDefinition.getManager(), typeDefinition.getName());
        mapConstructor.addParameter("args", "java.util.HashMap", false);
        mapConstructor.setConstructor(true);
        mapConstructor.setContainingClass(typeDefinition);
        return mapConstructor;
    }

    @NotNull
    private static GrLightMethodBuilder generateFieldConstructor(@NotNull GrTypeDefinition typeDefinition, @Nullable PsiAnnotation tupleConstructor, boolean immutable, boolean canonical) {
        GrLightMethodBuilder fieldsConstructor = new GrLightMethodBuilder(typeDefinition.getManager(), typeDefinition.getName());
        fieldsConstructor.setConstructor(true);
        fieldsConstructor.setNavigationElement(typeDefinition);
        fieldsConstructor.setContainingClass(typeDefinition);
        HashSet<String> excludes = new HashSet<String>();
        if (tupleConstructor != null) {
            for (String s : PsiUtil.getAnnoAttributeValue(tupleConstructor, "excludes", "").split(",")) {
                String name = s.trim();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                excludes.add(name);
            }
        }
        if (tupleConstructor != null) {
            boolean superFields = PsiUtil.getAnnoAttributeValue(tupleConstructor, "includeSuperFields", false);
            boolean superProperties = PsiUtil.getAnnoAttributeValue(tupleConstructor, "includeSuperProperties", false);
            if (superFields || superProperties) {
                ConstructorAnnotationsProcessor.addParametersForSuper(typeDefinition, fieldsConstructor, superFields, superProperties, new HashSet<PsiClass>(), excludes);
            }
        }
        ConstructorAnnotationsProcessor.addParameters(typeDefinition, fieldsConstructor, tupleConstructor == null || PsiUtil.getAnnoAttributeValue(tupleConstructor, "includeProperties", true), tupleConstructor != null ? PsiUtil.getAnnoAttributeValue(tupleConstructor, "includeFields", false) : !canonical, !immutable, excludes);
        if (immutable) {
            fieldsConstructor.setOriginInfo("created by @Immutable");
        } else if (tupleConstructor != null) {
            fieldsConstructor.setOriginInfo("created by @TupleConstructor");
        } else {
            fieldsConstructor.setOriginInfo("created by @Canonical");
        }
        return fieldsConstructor;
    }

    private static void addParametersForSuper(@NotNull PsiClass typeDefinition, GrLightMethodBuilder fieldsConstructor, boolean superFields, boolean superProperties, Set<PsiClass> visited, Set<String> excludes) {
        PsiClass parent = typeDefinition.getSuperClass();
        if (parent != null && visited.add(parent) && !"groovy.lang.GroovyObjectSupport".equals(parent.getQualifiedName())) {
            ConstructorAnnotationsProcessor.addParametersForSuper(parent, fieldsConstructor, superFields, superProperties, visited, excludes);
            ConstructorAnnotationsProcessor.addParameters(parent, fieldsConstructor, superProperties, superFields, true, excludes);
        }
    }

    private static void addParameters(@NotNull PsiClass psiClass, @NotNull GrLightMethodBuilder fieldsConstructor, boolean includeProperties, boolean includeFields, boolean optional, @NotNull Set<String> excludes) {
        PsiMethod[] methods = CollectClassMembersUtil.getMethods(psiClass, false);
        if (includeProperties) {
            for (PsiMethod method : methods) {
                String name;
                if (method.hasModifierProperty("static") || !PropertyUtil.isSimplePropertySetter((PsiMethod)method) || excludes.contains(name = PropertyUtil.getPropertyNameBySetter((PsiMethod)method))) continue;
                PsiType type = PropertyUtil.getPropertyType((PsiMember)method);
                assert (type != null) : method;
                fieldsConstructor.addParameter(new GrLightParameter(name, type, fieldsConstructor).setOptional(optional));
            }
        }
        Map properties = PropertyUtil.getAllProperties((boolean)true, (boolean)false, (PsiMethod[])methods);
        for (PsiField field : CollectClassMembersUtil.getFields(psiClass, false)) {
            String name = field.getName();
            if (!includeFields && (!includeProperties || !(field instanceof GrField) || !((GrField)field).isProperty()) || excludes.contains(name) || field.hasModifierProperty("static") || properties.containsKey(name)) continue;
            fieldsConstructor.addParameter(new GrLightParameter(name, field.getType(), fieldsConstructor).setOptional(optional));
        }
    }
}

