/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderHelperLightPsiClass;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class DefaultBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String DEFAULT_STRATEGY_NAME = "DefaultStrategy";

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        new DefaultBuilderStrategyHandler(context).doProcess();
    }

    @NotNull
    public static String getBuilderClassName(@NotNull PsiAnnotation annotation, @NotNull GrTypeDefinition clazz) {
        String builderClassName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderClassName");
        return builderClassName == null ? String.format("%s%s", clazz.getName(), "Builder") : builderClassName;
    }

    @NotNull
    public static LightMethodBuilder createBuildMethod(@NotNull PsiAnnotation annotation, @NotNull PsiType builtType) {
        LightMethodBuilder buildMethod = new LightMethodBuilder(annotation.getManager(), DefaultBuilderStrategySupport.getBuildMethodName(annotation));
        buildMethod.setOriginInfo("via @Builder");
        buildMethod.setMethodReturnType(builtType);
        return buildMethod;
    }

    @NotNull
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull GrVariable field, @NotNull PsiAnnotation annotation) {
        return DefaultBuilderStrategySupport.createFieldSetter(builderClass, field.getName(), field.getType(), annotation, field);
    }

    @NotNull
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull String name, @NotNull PsiType type, @NotNull PsiAnnotation annotation, @NotNull PsiElement navigationElement) {
        LightMethodBuilder fieldSetter = new LightMethodBuilder(builderClass.getManager(), DefaultBuilderStrategySupport.getFieldMethodName(annotation, name));
        fieldSetter.addModifier("public");
        fieldSetter.addParameter(name, type);
        fieldSetter.setContainingClass(builderClass);
        fieldSetter.setMethodReturnType((PsiType)JavaPsiFacade.getElementFactory((Project)builderClass.getProject()).createType(builderClass));
        fieldSetter.setNavigationElement(navigationElement);
        fieldSetter.setOriginInfo("via @Builder");
        return fieldSetter;
    }

    @NotNull
    public static String getFieldMethodName(@NotNull PsiAnnotation annotation, @NotNull String fieldName) {
        String prefix = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"prefix");
        return StringUtil.isEmpty((String)prefix) ? fieldName : String.format("%s%s", prefix, StringUtil.capitalize((String)fieldName));
    }

    @NotNull
    private static String getBuildMethodName(@NotNull PsiAnnotation annotation) {
        String buildMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"buildMethodName");
        return StringUtil.isEmpty((String)buildMethodName) ? "build" : buildMethodName;
    }

    private static class DefaultBuilderStrategyHandler {
        @NotNull
        private final TransformationContext myContext;
        @NotNull
        private final GrTypeDefinition myContainingClass;

        private DefaultBuilderStrategyHandler(@NotNull TransformationContext context) {
            this.myContext = context;
            this.myContainingClass = context.getCodeClass();
        }

        public void doProcess() {
            this.processTypeDefinition();
            this.processMethods();
        }

        private void processTypeDefinition() {
            PsiAnnotation builderAnno = PsiImplUtil.getAnnotation((PsiModifierListOwner)this.myContainingClass, "groovy.transform.builder.Builder");
            if (!BuilderAnnotationContributor.isApplicable(builderAnno, DefaultBuilderStrategySupport.DEFAULT_STRATEGY_NAME)) {
                return;
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(builderAnno, this.myContext.getCodeClass().getCodeFields());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, builderAnno));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull GrVariable[] setters) {
            return this.createBuilderClass(annotation, setters, null);
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull GrVariable[] setters, @Nullable PsiType builtType) {
            BuilderHelperLightPsiClass builderClass = new BuilderHelperLightPsiClass(this.myContainingClass, DefaultBuilderStrategySupport.getBuilderClassName(annotation, this.myContainingClass));
            for (GrVariable field : setters) {
                builderClass.addMethod((PsiMethod)DefaultBuilderStrategySupport.createFieldSetter((PsiClass)builderClass, field, annotation));
            }
            LightMethodBuilder buildMethod = DefaultBuilderStrategySupport.createBuildMethod(annotation, (PsiType)(builtType == null ? TypesUtil.createType(this.myContainingClass) : builtType));
            return builderClass.addMethod((PsiMethod)buildMethod);
        }

        @NotNull
        private LightMethodBuilder createBuilderMethod(@NotNull PsiClass builderClass, @NotNull PsiAnnotation annotation) {
            LightMethodBuilder builderMethod = new LightMethodBuilder(this.myContext.getManager(), DefaultBuilderStrategyHandler.getBuilderMethodName(annotation));
            builderMethod.addModifier("static");
            builderMethod.setOriginInfo("via @Builder");
            builderMethod.setNavigationElement((PsiElement)annotation);
            builderMethod.setMethodReturnType((PsiType)TypesUtil.createType(builderClass));
            return builderMethod;
        }

        private void processMethods() {
            for (GrMethod method : this.myContext.getCodeClass().getCodeMethods()) {
                this.processMethod(method);
            }
        }

        private void processMethod(@NotNull GrMethod method) {
            PsiAnnotation annotation = PsiImplUtil.getAnnotation(method, "groovy.transform.builder.Builder");
            if (!BuilderAnnotationContributor.isApplicable(annotation, DefaultBuilderStrategySupport.DEFAULT_STRATEGY_NAME)) {
                return;
            }
            if (method.isConstructor()) {
                this.processConstructor(method, annotation);
            } else if (method.hasModifierProperty("static")) {
                this.processFactoryMethod(method, annotation);
            }
        }

        private void processConstructor(@NotNull GrMethod method, PsiAnnotation annotation) {
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        private void processFactoryMethod(@NotNull GrMethod method, PsiAnnotation annotation) {
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters(), method.getReturnType());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private static String getBuilderMethodName(@NotNull PsiAnnotation annotation) {
            String builderMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderMethodName");
            return StringUtil.isEmpty((String)builderMethodName) ? "builder" : builderMethodName;
        }
    }
}

