/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy.DefaultBuilderStrategySupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class ExternalBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String EXTERNAL_STRATEGY_NAME = "ExternalStrategy";

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        PsiAnnotation annotation = PsiImplUtil.getAnnotation((PsiModifierListOwner)context.getCodeClass(), "groovy.transform.builder.Builder");
        if (!ExternalBuilderStrategySupport.isApplicable(annotation, EXTERNAL_STRATEGY_NAME)) {
            return;
        }
        PsiClass constructedClass = GrAnnotationUtil.inferClassAttribute(annotation, "forClass");
        if (constructedClass == null || "groovy.transform.Undefined.CLASS".equals(constructedClass.getQualifiedName())) {
            return;
        }
        if (constructedClass instanceof GrTypeDefinition) {
            for (GrField field : ((GrTypeDefinition)constructedClass).getCodeFields()) {
                context.addMethod((PsiMethod)DefaultBuilderStrategySupport.createFieldSetter(context.getCodeClass(), field, annotation));
            }
        } else {
            for (PsiMethod setter : PropertyUtil.getAllProperties((PsiClass)constructedClass, (boolean)true, (boolean)false).values()) {
                LightMethodBuilder builderSetter = ExternalBuilderStrategySupport.createFieldSetter(context.getCodeClass(), setter, annotation);
                if (builderSetter == null) continue;
                context.addMethod((PsiMethod)builderSetter);
            }
        }
        context.addMethod((PsiMethod)DefaultBuilderStrategySupport.createBuildMethod(annotation, (PsiType)TypesUtil.createType(constructedClass)));
    }

    @Nullable
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull PsiMethod setter, @NotNull PsiAnnotation annotation) {
        String name = PropertyUtil.getPropertyNameBySetter((PsiMethod)setter);
        PsiType type = PropertyUtil.getPropertyType((PsiMember)setter);
        if (type == null) {
            return null;
        }
        return DefaultBuilderStrategySupport.createFieldSetter(builderClass, name, type, annotation, (PsiElement)setter);
    }
}

