/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyAllVariantsProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessorImpl;

public final class GroovyResolverProcessorBuilder {
    private boolean myIncomplete = false;
    private boolean myAllVariants = false;
    private GrExpression myUpToArgument = null;
    private boolean myForceRValue = false;

    @NotNull
    public GroovyResolverProcessor build(GrReferenceExpression ref) {
        EnumSet<GroovyResolveKind> kinds;
        EnumSet<GroovyResolveKind> enumSet = kinds = this.myIncomplete ? EnumSet.allOf(GroovyResolveKind.class) : GroovyResolverProcessorBuilder.computeKinds(ref);
        if (this.myAllVariants) {
            return new GroovyAllVariantsProcessor(ref, kinds, this.myUpToArgument);
        }
        return new GroovyResolverProcessorImpl(ref, kinds, this.myForceRValue);
    }

    @NotNull
    public static GroovyResolverProcessorBuilder builder() {
        return new GroovyResolverProcessorBuilder();
    }

    public GroovyResolverProcessorBuilder setIncomplete(boolean incomplete) {
        this.myIncomplete = incomplete;
        return this;
    }

    @NotNull
    public GroovyResolverProcessorBuilder setAllVariants(boolean allVariants) {
        this.myAllVariants = allVariants;
        return this;
    }

    @NotNull
    public GroovyResolverProcessorBuilder setUpToArgument(GrExpression upToArgument) {
        this.myUpToArgument = upToArgument;
        return this;
    }

    @NotNull
    public GroovyResolverProcessorBuilder setForceRValue(boolean forceRValue) {
        this.myForceRValue = forceRValue;
        return this;
    }

    @NotNull
    private static EnumSet<GroovyResolveKind> computeKinds(@NotNull GrReferenceExpression ref) {
        if (ref.hasAt()) {
            return EnumSet.of(GroovyResolveKind.FIELD);
        }
        if (ref.hasMemberPointer()) {
            return EnumSet.of(GroovyResolveKind.METHOD);
        }
        EnumSet<GroovyResolveKind> result = EnumSet.allOf(GroovyResolveKind.class);
        if (!ResolveUtil.canBeClass(ref)) {
            result.remove((Object)GroovyResolveKind.CLASS);
        }
        if (!ResolveUtil.canBePackage(ref)) {
            result.remove((Object)GroovyResolveKind.PACKAGE);
        }
        if (ref.isQualified()) {
            result.remove((Object)GroovyResolveKind.BINDING);
        }
        if (!(ref.getParent() instanceof GrMethodCall)) {
            result.remove((Object)GroovyResolveKind.METHOD);
        }
        return result;
    }
}

