/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;

public class MvcModuleNode
extends AbstractModuleNode {
    private final MvcToolWindowDescriptor myDescriptor;

    public MvcModuleNode(@NotNull Module module, ViewSettings viewSettings, MvcToolWindowDescriptor descriptor2) {
        super(module.getProject(), module, viewSettings);
        this.myDescriptor = descriptor2;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> nodesList = new ArrayList<AbstractTreeNode>();
        Module module = (Module)this.getValue();
        ViewSettings viewSettings = this.getSettings();
        VirtualFile root = this.myDescriptor.getFramework().findAppRoot(module);
        if (root == null) {
            return Collections.emptyList();
        }
        this.myDescriptor.fillModuleChildren(nodesList, module, viewSettings, root);
        return nodesList;
    }

    public void update(PresentationData presentation) {
        super.update(presentation);
        Module module = (Module)this.getValue();
        if (module == null || module.isDisposed()) {
            this.setValue(null);
            return;
        }
        presentation.setIcon(this.myDescriptor.getModuleNodeIcon());
    }
}

