/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.projectView.AbstractFolderNode;
import org.jetbrains.plugins.groovy.mvc.projectView.AbstractMvcPsiNodeDescriptor;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcProjectNode;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcProjectViewState;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;

public class MvcProjectViewPane
extends AbstractProjectViewPSIPane
implements IdeView {
    private final CopyPasteDelegator myCopyPasteDelegator;
    private final JComponent myComponent;
    private final DeleteProvider myDeletePSIElementProvider;
    private final ModuleDeleteProvider myDeleteModuleProvider = new ModuleDeleteProvider();
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    @NonNls
    private final String myId;
    private final MvcToolWindowDescriptor myDescriptor;
    private final MvcProjectViewState myViewState;

    public MvcProjectViewPane(Project project, MvcToolWindowDescriptor descriptor2) {
        super(project);
        this.myDescriptor = descriptor2;
        this.myId = descriptor2.getToolWindowId();
        this.myViewState = descriptor2.getProjectViewState(project);
        class TreeUpdater
        implements Runnable,
        PsiModificationTracker.Listener {
            private volatile boolean myInQueue;

            TreeUpdater() {
            }

            @Override
            public void run() {
                if (MvcProjectViewPane.this.getTree() != null && MvcProjectViewPane.this.getTreeBuilder() != null) {
                    MvcProjectViewPane.this.updateFromRoot(true);
                }
                this.myInQueue = false;
            }

            public void modificationCountChanged() {
                if (!this.myInQueue) {
                    this.myInQueue = true;
                    ApplicationManager.getApplication().invokeLater((Runnable)this);
                }
            }
        }
        project.getMessageBus().connect((Disposable)this).subscribe(PsiModificationTracker.TOPIC, (Object)new TreeUpdater());
        this.myComponent = this.createComponent();
        DataManager.registerDataProvider((JComponent)this.myComponent, (DataProvider)this);
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.autoScrollToSource;
            }

            protected void setAutoScrollMode(boolean state) {
                ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.autoScrollToSource = state;
            }
        };
        this.myAutoScrollFromSourceHandler.install();
        this.myAutoScrollToSourceHandler.install(this.getTree());
        this.myAutoScrollToSourceHandler.onMouseClicked((Component)this.getTree());
        this.myCopyPasteDelegator = new CopyPasteDelegator(project, this.myComponent){

            @NotNull
            protected PsiElement[] getSelectedElements() {
                return MvcProjectViewPane.this.getSelectedPSIElements();
            }
        };
        this.myDeletePSIElementProvider = new DeleteHandler.DefaultDeleteProvider();
    }

    public void setup(ToolWindowEx toolWindow) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.myComponent, "Center");
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)p, null, false);
        content.setDisposer((Disposable)this);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(this.createComponent());
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new HideEmptyMiddlePackagesAction());
        group.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        group.add((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction());
        toolWindow.setAdditionalGearActions((ActionGroup)group);
        DefaultTreeExpander expander = new DefaultTreeExpander((JTree)this.myTree);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction collapseAction = actionsManager.createCollapseAllAction((TreeExpander)expander, (JComponent)this.myTree);
        collapseAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
        toolWindow.setTitleActions(new AnAction[]{new ScrollFromSourceAction(), collapseAction});
    }

    public String getTitle() {
        throw new UnsupportedOperationException();
    }

    public Icon getIcon() {
        return this.myDescriptor.getFramework().getIcon();
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    public int getWeight() {
        throw new UnsupportedOperationException();
    }

    public boolean isInitiallyVisible() {
        throw new UnsupportedOperationException();
    }

    public SelectInTarget createSelectInTarget() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected BaseProjectTreeBuilder createBuilder(DefaultTreeModel treeModel) {
        return new ProjectTreeBuilder(this.myProject, (JTree)this.myTree, treeModel, null, (ProjectAbstractTreeStructureBase)this.myTreeStructure){

            protected AbstractTreeUpdater createUpdater() {
                return MvcProjectViewPane.this.createTreeUpdater((AbstractTreeBuilder)this);
            }
        };
    }

    protected ProjectAbstractTreeStructureBase createStructure() {
        Project project = this.myProject;
        String id = this.getId();
        return new ProjectTreeStructure(project, id){

            public boolean isHideEmptyMiddlePackages() {
                return ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.hideEmptyMiddlePackages;
            }

            protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
                return new MvcProjectNode(project, (ViewSettings)this, MvcProjectViewPane.this.myDescriptor);
            }
        };
    }

    protected ProjectViewTree createTree(DefaultTreeModel treeModel) {
        return new ProjectViewTree(this.myProject, treeModel){

            public String toString() {
                return MvcProjectViewPane.this.myDescriptor.getFramework().getDisplayName() + " " + super.toString();
            }

            public DefaultMutableTreeNode getSelectedNode() {
                return MvcProjectViewPane.this.getSelectedNode();
            }
        };
    }

    protected AbstractTreeUpdater createTreeUpdater(AbstractTreeBuilder treeBuilder) {
        return new AbstractTreeUpdater(treeBuilder);
    }

    public Object getData(String dataId) {
        if ("psi.Element".equals(dataId)) {
            PsiElement[] elements = this.getSelectedPSIElements();
            return elements.length == 1 ? elements[0] : null;
        }
        if ("psi.Element.array".equals(dataId)) {
            return this.getSelectedPSIElements();
        }
        if ("context.Module".equals(dataId)) {
            Object element = this.getSelectedElement();
            if (element instanceof Module) {
                return element;
            }
            return null;
        }
        if ("context.Module.Array".equals(dataId)) {
            List moduleList = ContainerUtil.findAll((Object[])this.getSelectedElements(), Module.class);
            if (!moduleList.isEmpty()) {
                return moduleList.toArray(new Module[moduleList.size()]);
            }
            return null;
        }
        if (dataId.equals("IDEView")) {
            return this;
        }
        if (dataId.equals(DataConstants.HELP_ID)) {
            return "reference.toolwindows." + this.myId.toLowerCase();
        }
        if (DataConstants.CUT_PROVIDER.equals(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (DataConstants.COPY_PROVIDER.equals(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (DataConstants.PASTE_PROVIDER.equals(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (DataConstants.DELETE_ELEMENT_PROVIDER.equals(dataId)) {
            for (Object element : this.getSelectedElements()) {
                if (!(element instanceof Module)) continue;
                return this.myDeleteModuleProvider;
            }
            return this.myDeletePSIElementProvider;
        }
        return super.getData(dataId);
    }

    @Nullable
    public static MvcProjectViewPane getView(Project project, MvcFramework framework) {
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(MvcToolWindowDescriptor.getToolWindowId(framework));
        Content content = window == null ? null : window.getContentManager().getContent(0);
        return content == null ? null : (MvcProjectViewPane)content.getDisposer();
    }

    public void selectElement(PsiElement element) {
        Editor editor;
        PsiFileSystemItem psiFile;
        if (element instanceof PsiFileSystemItem) {
            psiFile = (PsiFileSystemItem)element;
        } else {
            psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.selectFile(virtualFile, false);
        boolean requestFocus = true;
        if (psiFile instanceof PsiFile && (editor = EditorHelper.openInEditor((PsiElement)element)) != null) {
            ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
            requestFocus = false;
        }
        if (requestFocus) {
            this.selectFile(virtualFile, true);
        }
    }

    @NotNull
    public PsiDirectory[] getDirectories() {
        return this.getSelectedDirectories();
    }

    public PsiDirectory getOrChooseDirectory() {
        return DirectoryChooserUtil.getOrChooseDirectory((IdeView)this);
    }

    public static boolean canSelectFile(@NotNull Project project, @NotNull MvcFramework framework, VirtualFile file) {
        return MvcProjectViewPane.getSelectPath(project, framework, file) != null;
    }

    @Nullable
    private List<Object> getSelectPath(VirtualFile file) {
        return MvcProjectViewPane.getSelectPath(this.myProject, this.myDescriptor.getFramework(), file);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static List<Object> getSelectPath(@NotNull Project project, @NotNull MvcFramework framework, VirtualFile file) {
        AbstractTreeNode descriptor2;
        AbstractTreeNode abstractTreeNode;
        if (file == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || !framework.hasSupport(module)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        MvcProjectViewPane view = MvcProjectViewPane.getView(project, framework);
        if (view == null) {
            return null;
        }
        MvcProjectNode root = (MvcProjectNode)((Object)view.getTreeBuilder().getTreeStructure().getRootElement());
        result.add((Object)root);
        Iterator<? extends AbstractTreeNode> iterator = root.getChildren().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((abstractTreeNode = iterator.next()).getValue() != module);
        result.add(abstractTreeNode);
        Object cur = abstractTreeNode;
        block1: while (true) {
            Iterator iterator2 = cur.getChildren().iterator();
            do {
                AbstractFolderNode folderNode;
                VirtualFile dir;
                if (!iterator2.hasNext()) {
                    return null;
                }
                descriptor2 = (AbstractTreeNode)iterator2.next();
                if (!(descriptor2 instanceof AbstractFolderNode) || (dir = (folderNode = (AbstractFolderNode)descriptor2).getVirtualFile()) == null || !VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)false)) continue;
                cur = folderNode;
                result.add((Object)folderNode);
                if (!dir.equals(file)) continue block1;
                return result;
            } while (!(descriptor2 instanceof AbstractMvcPsiNodeDescriptor) || !file.equals(((AbstractMvcPsiNodeDescriptor)descriptor2).getVirtualFile()));
            break;
        }
        result.add(descriptor2);
        return result;
    }

    public boolean canSelectFile(VirtualFile file) {
        return this.getSelectPath(file) != null;
    }

    private void selectElementAtCaret(Editor editor, boolean requestFocus) {
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        this.selectFile(file, requestFocus);
    }

    public void selectFile(@Nullable PsiFile file, boolean requestFocus) {
        if (file == null) {
            return;
        }
        this.selectFile(file.getVirtualFile(), requestFocus);
    }

    public void selectFile(@Nullable VirtualFile file, boolean requestFocus) {
        if (file == null) {
            return;
        }
        List<Object> path = this.getSelectPath(file);
        if (path == null) {
            return;
        }
        Object value = ((AbstractTreeNode)path.get(path.size() - 1)).getValue();
        this.select(value, file, requestFocus);
    }

    public void scrollFromSource() {
        FileEditor[] editors;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        Editor selectedTextEditor = fileEditorManager.getSelectedTextEditor();
        if (selectedTextEditor != null) {
            this.selectElementAtCaret(selectedTextEditor, false);
            return;
        }
        for (FileEditor fileEditor : editors = fileEditorManager.getSelectedEditors()) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            this.selectElementAtCaret(editor, false);
            return;
        }
        VirtualFile[] selectedFiles = fileEditorManager.getSelectedFiles();
        if (selectedFiles.length > 0) {
            PsiFile file = PsiManager.getInstance((Project)this.myProject).findFile(selectedFiles[0]);
            this.selectFile(file, false);
        }
    }

    private void selectElementAtCaretNotLosingFocus() {
        if (IJSwingUtilities.hasFocus((Component)this.getComponentToFocus())) {
            return;
        }
        this.scrollFromSource();
    }

    private class HideEmptyMiddlePackagesAction
    extends ToggleAction
    implements DumbAware {
        private HideEmptyMiddlePackagesAction() {
            super("Compact Empty Middle Packages", "Show/Compact Empty Middle Packages", AllIcons.ObjectBrowser.CompactEmptyPackages);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.hideEmptyMiddlePackages;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.hideEmptyMiddlePackages = flag;
            TreeUtil.collapseAll((JTree)MvcProjectViewPane.this.myTree, (int)1);
        }
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        protected MyAutoScrollFromSourceHandler() {
            super(MvcProjectViewPane.this.myProject, MvcProjectViewPane.this.myComponent, (Disposable)MvcProjectViewPane.this);
        }

        protected boolean isAutoScrollEnabled() {
            return ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.autoScrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state) {
            ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.autoScrollFromSource = state;
            if (state) {
                MvcProjectViewPane.this.selectElementAtCaretNotLosingFocus();
            }
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            MvcProjectViewPane.this.selectElementAtCaretNotLosingFocus();
        }
    }

    private class ScrollFromSourceAction
    extends AnAction
    implements DumbAware {
        private ScrollFromSourceAction() {
            super("Scroll from Source", "Select the file open in the active editor", AllIcons.General.Locate);
        }

        public void actionPerformed(AnActionEvent e) {
            MvcProjectViewPane.this.scrollFromSource();
        }
    }
}

