/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GrParameterInfo
implements JavaParameterInfo {
    @NotNull
    private String myName;
    @NotNull
    private String myDefaultValue = "";
    @NotNull
    private String myDefaultInitializer = "";
    private final int myPosition;
    @Nullable
    private CanonicalTypes.Type myTypeWrapper;
    private boolean myUseAnySingleVariable;

    public GrParameterInfo(GrParameter parameter, int position) {
        this.myPosition = position;
        this.myName = parameter.getName();
        PsiType type = parameter.getDeclaredType();
        this.myTypeWrapper = type != null ? CanonicalTypes.createTypeWrapper((PsiType)type) : (parameter.hasModifierProperty("def") ? CanonicalTypes.createTypeWrapper((PsiType)JavaPsiFacade.getElementFactory((Project)parameter.getProject()).createTypeFromText("def", null)) : null);
        GrExpression defaultInitializer = parameter.getInitializerGroovy();
        if (defaultInitializer != null) {
            this.setInitializer(defaultInitializer.getText());
        }
        this.myUseAnySingleVariable = false;
    }

    public GrParameterInfo(@NotNull String name, @Nullable String defaultValue, @Nullable String defaultInitializer, @Nullable PsiType type, int position, boolean useAnySingleVariable) {
        this.myName = name;
        this.myPosition = position;
        this.myUseAnySingleVariable = useAnySingleVariable;
        this.setType(type);
        this.setDefaultValue(defaultValue);
        this.setInitializer(defaultInitializer);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public int getOldIndex() {
        return this.myPosition;
    }

    @NotNull
    public String getDefaultValue() {
        return this.forceOptional() ? this.getDefaultInitializer() : this.myDefaultValue;
    }

    @Nullable
    public PsiType createType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
        return this.myTypeWrapper != null ? this.myTypeWrapper.getType(context, manager) : null;
    }

    @NotNull
    public String getTypeText() {
        return this.myTypeWrapper != null ? this.myTypeWrapper.getTypeText() : "";
    }

    @Nullable
    public CanonicalTypes.Type getTypeWrapper() {
        return this.myTypeWrapper;
    }

    public PsiExpression getValue(PsiCallExpression callExpression) {
        return JavaPsiFacade.getElementFactory((Project)callExpression.getProject()).createExpressionFromText(this.getDefaultValue(), (PsiElement)callExpression);
    }

    public boolean isVarargType() {
        return this.getTypeText().endsWith("...") || this.getTypeText().endsWith("[]");
    }

    public boolean isUseAnySingleVariable() {
        return this.myUseAnySingleVariable;
    }

    public void setUseAnySingleVariable(boolean useAnyVar) {
        this.myUseAnySingleVariable = useAnyVar;
    }

    public boolean isOptional() {
        return !this.getDefaultInitializer().isEmpty();
    }

    @NotNull
    public String getDefaultInitializer() {
        return this.myDefaultInitializer;
    }

    public boolean hasNoType() {
        return this.getTypeText().isEmpty();
    }

    public boolean forceOptional() {
        return this.myPosition < 0 && StringUtil.isEmpty((String)this.myDefaultValue);
    }

    public void setName(String newName) {
        this.myName = StringUtil.notNullize((String)newName);
    }

    public void setType(@Nullable PsiType type) {
        this.myTypeWrapper = type == null ? null : CanonicalTypes.createTypeWrapper((PsiType)type);
    }

    public void setInitializer(@Nullable String initializer) {
        this.myDefaultInitializer = StringUtil.notNullize((String)initializer);
    }

    public void setDefaultValue(@Nullable String defaultValue) {
        this.myDefaultValue = StringUtil.notNullize((String)defaultValue);
    }
}

