/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class GrParameterTableModelItem
extends ParameterTableModelItemBase<GrParameterInfo> {
    public PsiCodeFragment initializerCodeFragment;

    public GrParameterTableModelItem(GrParameterInfo parameter, PsiCodeFragment typeCodeFragment, PsiCodeFragment initializerCodeFragment, PsiCodeFragment defaultValueCodeFragment) {
        super((Object)parameter, typeCodeFragment, defaultValueCodeFragment);
        this.initializerCodeFragment = initializerCodeFragment;
    }

    public static GrParameterTableModelItem create(@Nullable GrParameterInfo parameterInfo, @NotNull Project project, @Nullable PsiElement context) {
        if (parameterInfo == null) {
            parameterInfo = new GrParameterInfo("", "", "", null, -1, false);
        }
        PsiTypeCodeFragment typeCodeFragment = JavaCodeFragmentFactory.getInstance((Project)project).createTypeCodeFragment(parameterInfo.getTypeText(), context, true, 2);
        String initializer = parameterInfo.getDefaultInitializer();
        GroovyCodeFragment initializerCodeFragment = new GroovyCodeFragment(project, initializer != null ? initializer : "");
        GroovyCodeFragment defaultValueCodeFragment = new GroovyCodeFragment(project, parameterInfo.getDefaultValue());
        return new GrParameterTableModelItem(parameterInfo, (PsiCodeFragment)typeCodeFragment, (PsiCodeFragment)initializerCodeFragment, (PsiCodeFragment)defaultValueCodeFragment);
    }

    public boolean isEllipsisType() {
        try {
            PsiType type = ((PsiTypeCodeFragment)this.typeCodeFragment).getType();
            return type instanceof PsiArrayType;
        }
        catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
            return false;
        }
    }
}

