/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.Generator;

public class AnnotationGenerator
extends Generator {
    private final StringBuilder builder;
    private final ExpressionContext context;
    private final ExpressionGenerator expressionGenerator;

    public AnnotationGenerator(StringBuilder builder, ExpressionContext context) {
        this.builder = builder;
        this.context = context.extend();
        this.expressionGenerator = new ExpressionGenerator(builder, context);
    }

    @Override
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public ExpressionContext getContext() {
        return this.context;
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        expression.accept(this.expressionGenerator);
    }

    @Override
    public void visitAnnotationArrayInitializer(@NotNull GrAnnotationArrayInitializer arrayInitializer) {
        GrAnnotationMemberValue[] initializers = arrayInitializer.getInitializers();
        this.builder.append('{');
        for (GrAnnotationMemberValue initializer : initializers) {
            initializer.accept(this);
            this.builder.append(", ");
        }
        if (initializers.length > 0) {
            this.builder.delete(this.builder.length() - 2, this.builder.length());
        }
        this.builder.append('}');
    }

    @Override
    public void visitAnnotation(@NotNull GrAnnotation annotation) {
        this.builder.append('@');
        GrCodeReferenceElement classReference = annotation.getClassReference();
        GenerationUtil.writeCodeReferenceElement(this.builder, classReference);
        GrAnnotationArgumentList parameterList = annotation.getParameterList();
        GrAnnotationNameValuePair[] attributes = parameterList.getAttributes();
        if (attributes.length == 0) {
            return;
        }
        this.builder.append('(');
        for (GrAnnotationNameValuePair attribute : attributes) {
            GrAnnotationMemberValue value;
            String name = attribute.getName();
            if (name != null) {
                this.builder.append(name);
                this.builder.append(" = ");
            }
            if ((value = attribute.getValue()) != null) {
                value.accept(this);
            }
            this.builder.append(", ");
        }
        this.builder.delete(this.builder.length() - 2, this.builder.length());
        this.builder.append(')');
    }
}

