/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.google.common.collect.ImmutableSortedSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.noReturnMethod.MissingReturnInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumConstantInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.AnnotationGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ArgumentListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassItemGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.CodeBlockGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationSettings;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ModifierListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.SetterWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;
import org.jetbrains.plugins.groovy.transformations.impl.GroovyObjectTransformationSupport;

public class ClassItemGeneratorImpl
implements ClassItemGenerator {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassItemGeneratorImpl");
    private final ClassNameProvider classNameProvider = new GeneratorClassNameProvider();
    private final ExpressionContext context;

    public ClassItemGeneratorImpl(@NotNull ExpressionContext context) {
        this.context = context;
    }

    @Override
    public void writeEnumConstant(StringBuilder builder, GrEnumConstant constant) {
        GrEnumConstantInitializer anonymousBlock;
        GenerationUtil.writeDocComment(builder, constant, false);
        builder.append(constant.getName());
        GrArgumentList argumentList = constant.getArgumentList();
        if (argumentList != null) {
            GroovyResolveResult resolveResult = constant.advancedResolve();
            GrClosureSignature signature = GrClosureSignatureUtil.createSignature(resolveResult);
            new ArgumentListGenerator(builder, this.context.extend()).generate(signature, argumentList.getExpressionArguments(), argumentList.getNamedArguments(), GrClosableBlock.EMPTY_ARRAY, constant);
        }
        if ((anonymousBlock = constant.getInitializingClass()) != null) {
            builder.append("{\n");
            new ClassGenerator(this.classNameProvider, this).writeMembers(builder, anonymousBlock);
            builder.append("\n}");
        }
    }

    @Override
    public void writeConstructor(StringBuilder text, PsiMethod constructor, boolean isEnum) {
        this.writeMethod(text, constructor);
    }

    @Override
    public void writeMethod(StringBuilder builder, PsiMethod method) {
        GrAnnotationMemberValue defaultValue;
        if (method == null) {
            return;
        }
        GenerationUtil.writeDocComment(builder, (PsiMember)method, true);
        String name = method.getName();
        boolean isAbstract = method.hasModifierProperty("abstract");
        PsiModifierList modifierList = method.getModifierList();
        PsiClass containingClass = method.getContainingClass();
        if (method.isConstructor() && containingClass != null && containingClass.isEnum()) {
            ModifierListGenerator.writeModifiers(builder, modifierList, ModifierListGenerator.ENUM_CONSTRUCTOR_MODIFIERS);
        } else {
            ModifierListGenerator.writeModifiers(builder, modifierList);
        }
        if (method.hasTypeParameters()) {
            GenerationUtil.writeTypeParameters(builder, (PsiTypeParameterListOwner)method, this.classNameProvider);
            builder.append(' ');
        }
        if (!method.isConstructor()) {
            PsiType retType = this.context.typeProvider.getReturnType(method);
            TypeWriter.writeType(builder, retType, (PsiElement)method, this.classNameProvider);
            builder.append(' ');
        }
        builder.append(name);
        if (method instanceof GroovyPsiElement) {
            this.context.searchForLocalVarsToWrap((GroovyPsiElement)method);
        }
        GenerationUtil.writeParameterList(builder, method.getParameterList().getParameters(), this.classNameProvider, this.context);
        if (method instanceof GrAnnotationMethod && (defaultValue = ((GrAnnotationMethod)method).getDefaultValue()) != null) {
            builder.append("default ");
            defaultValue.accept(new AnnotationGenerator(builder, this.context));
        }
        GenerationUtil.writeThrowsList(builder, method.getThrowsList(), this.getMethodExceptions(method), this.classNameProvider);
        if (!isAbstract) {
            if (method instanceof GrMethod) {
                if (method instanceof GrReflectedMethod && ((GrReflectedMethod)method).getSkippedParameters().length > 0) {
                    builder.append("{\n").append((CharSequence)this.generateDelegateCall((GrReflectedMethod)method)).append("\n}\n");
                } else {
                    new CodeBlockGenerator(builder, this.context.extend()).generateMethodBody((GrMethod)method);
                }
            } else if (method instanceof GrAccessorMethod) {
                ClassItemGeneratorImpl.writeAccessorBody(builder, method);
            } else if (method instanceof LightMethodBuilder && containingClass instanceof GroovyScriptClass) {
                if ("main".equals(method.getName())) {
                    this.writeMainScriptMethodBody(builder, method);
                } else if ("run".equals(method.getName())) {
                    this.writeRunScriptMethodBody(builder, method);
                }
            } else {
                builder.append("{//todo\n}");
            }
        } else {
            builder.append(';');
        }
    }

    private StringBuilder generateDelegateCall(GrReflectedMethod method) {
        GrParameter[] actualParams = method.getParameterList().getParameters();
        GrParameter[] parameters = method.getBaseMethod().getParameters();
        HashSet actual = new HashSet(actualParams.length);
        for (GrParameter param : actualParams) {
            actual.add(param.getName());
        }
        StringBuilder builder = new StringBuilder();
        if (method.isConstructor()) {
            builder.append("this");
        } else {
            if (!PsiType.VOID.equals((Object)this.context.typeProvider.getReturnType(method))) {
                builder.append("return ");
            }
            builder.append(method.getName());
        }
        builder.append('(');
        for (GrParameter parameter : parameters) {
            if (actual.contains(parameter.getName())) {
                builder.append(parameter.getName());
            } else {
                LOG.assertTrue(parameter.isOptional());
                GrExpression initializer = parameter.getInitializerGroovy();
                LOG.assertTrue(initializer != null);
                builder.append(initializer.getText());
            }
            builder.append(", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        builder.append(')');
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.context.project);
        GrStatement delegateCall = method.isConstructor() ? factory.createConstructorInvocation(builder.toString(), method) : factory.createStatementFromText(builder.toString(), method);
        StringBuilder result = new StringBuilder();
        delegateCall.accept(new CodeBlockGenerator(result, this.context.extend()));
        return result;
    }

    private void writeMainScriptMethodBody(StringBuilder builder, PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        LOG.assertTrue(containingClass instanceof GroovyScriptClass);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        LOG.assertTrue(parameters.length == 1);
        builder.append("{\nnew ").append(containingClass.getQualifiedName()).append("(new groovy.lang.Binding(").append(parameters[0].getName()).append(")).run();\n}\n");
    }

    private void writeRunScriptMethodBody(StringBuilder builder, PsiMethod method) {
        builder.append("{\n");
        PsiClass containingClass = method.getContainingClass();
        LOG.assertTrue(containingClass instanceof GroovyScriptClass);
        PsiFile scriptFile = containingClass.getContainingFile();
        LOG.assertTrue(scriptFile instanceof GroovyFile);
        LOG.assertTrue(((GroovyFile)scriptFile).isScript());
        List<GrStatement> exitPoints = ControlFlowUtils.collectReturns((PsiElement)scriptFile);
        ExpressionContext extended = this.context.extend();
        extended.searchForLocalVarsToWrap((GroovyPsiElement)scriptFile);
        new CodeBlockGenerator(builder, extended, exitPoints).visitStatementOwner((GroovyFile)scriptFile, MissingReturnInspection.methodMissesSomeReturns((GroovyFile)scriptFile, MissingReturnInspection.ReturnStatus.mustReturnValue));
        builder.append("\n}\n");
    }

    private static void writeAccessorBody(StringBuilder builder, PsiMethod method) {
        String propName = ((GrAccessorMethod)method).getProperty().getName();
        if (((GrAccessorMethod)method).isSetter()) {
            String paramName = method.getParameterList().getParameters()[0].getName();
            builder.append("{\n");
            if (method.hasModifierProperty("static")) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null) {
                    builder.append(containingClass.getName());
                    builder.append('.');
                }
            } else {
                builder.append("this.");
            }
            builder.append(propName);
            builder.append(" = ");
            builder.append(paramName);
            builder.append(";\n}");
        } else {
            builder.append("{\n return ");
            builder.append(propName);
            builder.append(";\n}");
        }
    }

    private PsiClassType[] getMethodExceptions(PsiMethod method) {
        return method.getThrowsList().getReferencedTypes();
    }

    @Override
    public void writeVariableDeclarations(StringBuilder mainBuilder, GrVariableDeclaration variableDeclaration) {
        ExpressionContext extended = this.context.extend();
        GrVariable[] variables = variableDeclaration.getVariables();
        if (variables.length > 0 && variables[0] instanceof PsiField) {
            GenerationUtil.writeDocComment(mainBuilder, (PsiMember)((PsiField)variables[0]), true);
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder initBuilder = new StringBuilder();
        initBuilder.append("{\n");
        for (GrVariable variable : variables) {
            PsiType type = extended.typeProvider.getVarType(variable);
            ModifierListGenerator.writeModifiers(builder, variable.getModifierList());
            TypeWriter.writeType(builder, type, variable);
            builder.append(' ');
            builder.append(variable.getName());
            GrExpression initializer = variable.getInitializerGroovy();
            if (initializer != null) {
                int count = extended.myStatements.size();
                StringBuilder initializerBuilder = new StringBuilder();
                extended.searchForLocalVarsToWrap(initializer);
                initializer.accept(new ExpressionGenerator(initializerBuilder, extended));
                if (extended.myStatements.size() == count) {
                    builder.append(" = ").append((CharSequence)initializerBuilder);
                } else {
                    StringBuilder assignment = new StringBuilder().append(variable.getName()).append(" = ").append((CharSequence)initializerBuilder).append(';');
                    GenerationUtil.writeStatement(initBuilder, assignment, null, extended);
                }
            }
            builder.append(";\n");
        }
        if (!extended.myStatements.isEmpty()) {
            initBuilder.append("}\n");
            mainBuilder.append((CharSequence)initBuilder);
        }
        mainBuilder.append((CharSequence)builder);
    }

    @Override
    public Collection<PsiMethod> collectMethods(PsiClass typeDefinition) {
        List result = ContainerUtil.filter((Object[])typeDefinition.getMethods(), m -> !GroovyObjectTransformationSupport.isGroovyObjectSupportMethod(m));
        if (typeDefinition instanceof GroovyScriptClass) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.context.project);
            String name = typeDefinition.getName();
            GrTypeDefinition tempClass = factory.createTypeDefinition("class " + name + " extends groovy.lang.Script {\n  def " + name + "(groovy.lang.Binding binding){\n    super(binding);\n  }\n  def " + name + "(){\n    super();\n  }\n}");
            ContainerUtil.addAll((Collection)result, (Object[])tempClass.getCodeConstructors());
        }
        return result;
    }

    @Override
    public boolean generateAnnotations() {
        return true;
    }

    @Override
    public void writePostponed(StringBuilder builder, PsiClass psiClass) {
        if (psiClass.getContainingClass() != null) {
            return;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return;
        }
        Map<PsiMethod, String> setters = this.context.getSetters();
        ImmutableSortedSet entries = setters.entrySet();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            entries = ImmutableSortedSet.copyOf(Comparator.comparing(Map.Entry::getValue), entries);
        }
        for (Map.Entry<PsiMethod, String> entry : entries) {
            new SetterWriter(builder, psiClass, entry.getKey(), entry.getValue(), this.classNameProvider, this.context).write();
        }
        String name = this.context.getRefSetterName();
        if (name != null) {
            builder.append("private static <T> T ").append(name).append("(groovy.lang.Reference<T> ref, T newValue) {\nref.set(newValue);\nreturn newValue;\n}");
        }
    }

    @Override
    public void writeImplementsList(StringBuilder text, PsiClass typeDefinition) {
        LinkedHashSet implementsTypes = new LinkedHashSet();
        Collections.addAll(implementsTypes, typeDefinition.getImplementsListTypes());
        if (implementsTypes.isEmpty()) {
            return;
        }
        if (implementsTypes.size() == 1 && ClassItemGeneratorImpl.shouldSkipInImplements(typeDefinition, (PsiClassType)implementsTypes.iterator().next())) {
            return;
        }
        text.append(typeDefinition.isInterface() ? "extends " : "implements ");
        for (PsiClassType implementsType : implementsTypes) {
            if (ClassItemGeneratorImpl.shouldSkipInImplements(typeDefinition, implementsType)) continue;
            TypeWriter.writeType(text, (PsiType)implementsType, (PsiElement)typeDefinition, this.classNameProvider);
            text.append(", ");
        }
        if (!implementsTypes.isEmpty()) {
            text.delete(text.length() - 2, text.length());
        }
        text.append(' ');
    }

    private static boolean shouldSkipInImplements(PsiClass typeDefinition, PsiClassType implementsType) {
        return implementsType.equalsToText("groovy.lang.GroovyObject") && typeDefinition instanceof GrTypeDefinition && !typeDefinition.isInterface() && !GenerationSettings.implementGroovyObjectAlways && !ClassItemGeneratorImpl.isInList(implementsType, ((GrTypeDefinition)typeDefinition).getImplementsClause()) && !ClassItemGeneratorImpl.containsMethodsOf((GrTypeDefinition)typeDefinition, "groovy.lang.GroovyObject");
    }

    @Override
    public void writeExtendsList(StringBuilder text, PsiClass typeDefinition) {
        PsiClassType[] extendsClassesTypes = typeDefinition.getExtendsListTypes();
        PsiClassType type = null;
        if (extendsClassesTypes.length > 0) {
            type = extendsClassesTypes[0];
        } else if (typeDefinition instanceof GrTypeDefinition && (GenerationSettings.implementGroovyObjectAlways || ClassItemGeneratorImpl.containsMethodsOf((GrTypeDefinition)typeDefinition, "groovy.lang.GroovyObject"))) {
            type = TypesUtil.createType("groovy.lang.GroovyObjectSupport", (PsiElement)typeDefinition);
        }
        if (type != null) {
            text.append("extends ");
            TypeWriter.writeType(text, (PsiType)type, (PsiElement)typeDefinition, this.classNameProvider);
            text.append(' ');
        }
    }

    private static boolean isInList(@NotNull PsiClassType type, @Nullable GrReferenceList list) {
        GrCodeReferenceElement[] elements;
        if (list == null) {
            return false;
        }
        PsiClass resolved = type.resolve();
        if (resolved == null) {
            return true;
        }
        PsiManager manager = list.getManager();
        for (GrCodeReferenceElement element : elements = list.getReferenceElementsGroovy()) {
            if (!manager.areElementsEquivalent((PsiElement)resolved, element.resolve())) continue;
            return true;
        }
        return false;
    }

    private static boolean containsMethodsOf(@NotNull GrTypeDefinition aClass, @NotNull String fqn) {
        PsiClass classToSearch = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(fqn, aClass.getResolveScope());
        if (classToSearch == null) {
            return true;
        }
        HashSet methodsToFind = new HashSet();
        for (PsiMethod psiMethod : classToSearch.getMethods()) {
            methodsToFind.add(psiMethod.getName());
        }
        for (PsiMethod psiMethod : aClass.getCodeMethods()) {
            if (!methodsToFind.contains(psiMethod.getName())) continue;
            for (HierarchicalMethodSignature superSignature : psiMethod.getHierarchicalMethodSignature().getSuperSignatures()) {
                PsiClass superClass = superSignature.getMethod().getContainingClass();
                if (superClass == null || !fqn.equals(superClass.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }
}

